/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.Shard;
import com.amazonaws.services.dynamodbv2.model.transform.SequenceNumberRangeJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ShardJsonMarshaller {
    private static ShardJsonMarshaller instance;

    public void marshall(Shard shard, JSONWriter jsonWriter) {
        if (shard == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (shard.getShardId() != null) {
                jsonWriter.key("ShardId").value(shard.getShardId());
            }
            if (shard.getSequenceNumberRange() != null) {
                jsonWriter.key("SequenceNumberRange");
                SequenceNumberRangeJsonMarshaller.getInstance().marshall(shard.getSequenceNumberRange(), jsonWriter);
            }
            if (shard.getParentShardId() != null) {
                jsonWriter.key("ParentShardId").value(shard.getParentShardId());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ShardJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ShardJsonMarshaller();
        }
        return instance;
    }
}

