/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.retrieval.mgmt;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.duracloud.common.model.ContentItem;
import org.duracloud.retrieval.mgmt.OutputWriter;

public class CSVFileOutputWriter
implements OutputWriter {
    protected static final String SUCCESS = "success";
    protected static final String FAILURE = "failure";
    protected static final String OUTPUT_PREFIX = "retrieval-tool-output-";
    private PrintWriter writer;

    public CSVFileOutputWriter(File workDir) {
        SimpleDateFormat nameFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        String writerFileName = OUTPUT_PREFIX + nameFormat.format(new Date()) + ".csv";
        File writerFile = new File(workDir, writerFileName);
        try {
            this.writer = new PrintWriter(new BufferedWriter(new FileWriter(writerFile)));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize output writer due to: " + e.getMessage());
        }
        this.writeHeader();
    }

    private void writeHeader() {
        this.writer.println("result, spaceId, contentId, local file, error, attempts, date");
        this.writer.flush();
    }

    @Override
    public void writeSuccess(ContentItem contentItem, String localFilePath, int attempts) {
        StringBuilder result = new StringBuilder();
        result.append(SUCCESS).append(",");
        result.append(contentItem.getSpaceId()).append(",");
        result.append(this.quote(contentItem.getContentId())).append(",");
        result.append(this.quote(localFilePath)).append(",");
        result.append("none").append(",");
        result.append(attempts).append(",");
        result.append(DATE_FORMAT.format(new Date()));
        this.writer.println(result.toString());
        this.writer.flush();
    }

    @Override
    public void writeFailure(ContentItem contentItem, String error, int attempts) {
        StringBuilder result = new StringBuilder();
        result.append(FAILURE).append(",");
        result.append(contentItem.getSpaceId()).append(",");
        result.append(this.quote(contentItem.getContentId())).append(",");
        result.append("none").append(",");
        result.append(this.quote(error)).append(",");
        result.append(attempts).append(",");
        result.append(DATE_FORMAT.format(new Date()));
        this.writer.println(result.toString());
        this.writer.flush();
    }

    private String quote(String toCheck) {
        if (toCheck.indexOf(",") > -1) {
            return "\"" + toCheck + "\"";
        }
        return toCheck;
    }

    @Override
    public void close() {
        this.writer.close();
    }
}

