/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.duracloud.common.collection.WriteOnlyStringSet;
import org.duracloud.snapshot.service.impl.ManifestEntry;

public class ManifestFileHelper {
    public static final String MANIFEST_MD5_TEXT_FILE_NAME = "manifest-md5.txt";
    private static final Pattern MANIFEST_LINE_PATTERN = Pattern.compile("(\\w*)[\\s^\\r^\\n]+data/(.*)");

    public static void writeManifestEntry(Writer writer, String contentId, String checksum) throws IOException {
        writer.write(checksum + "  data/" + contentId + "\n");
    }

    public static ManifestEntry parseManifestEntry(String line) throws ParseException {
        try {
            Matcher matcher = MANIFEST_LINE_PATTERN.matcher(line);
            matcher.find();
            String checksum = matcher.group(1);
            String contentId = matcher.group(2);
            return new ManifestEntry(checksum, contentId);
        }
        catch (Exception ex) {
            throw new ParseException(MessageFormat.format("failed to parse \"{0}\": does not match regex (\"{1}\")", line, MANIFEST_LINE_PATTERN.pattern()), 0);
        }
    }

    public static WriteOnlyStringSet loadManifestSetFromFile(File manifestFile) throws Exception {
        Throwable throwable;
        BufferedReader breader;
        int count = 0;
        try {
            breader = new BufferedReader(new FileReader(manifestFile));
            throwable = null;
            try {
                while (breader.readLine() != null) {
                    ++count;
                }
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (breader != null) {
                    if (throwable != null) {
                        try {
                            breader.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        breader.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        WriteOnlyStringSet manifestSet = new WriteOnlyStringSet(count);
        try {
            breader = new BufferedReader(new FileReader(manifestFile));
            throwable = null;
            try {
                String line = null;
                while ((line = breader.readLine()) != null) {
                    ManifestEntry entry = ManifestFileHelper.parseManifestEntry(line);
                    manifestSet.add(ManifestFileHelper.formatManifestSetString(entry.getContentId(), entry.getChecksum()));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (breader != null) {
                    if (throwable != null) {
                        try {
                            breader.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        breader.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return manifestSet;
    }

    public static String formatManifestSetString(String contentId, String checksum) {
        return contentId + ":" + checksum;
    }
}

