/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import org.duracloud.client.ContentStore;
import org.duracloud.common.model.ContentItem;
import org.duracloud.manifeststitch.StitchedManifestGenerator;
import org.duracloud.retrieval.mgmt.LoggingOutputWriter;
import org.duracloud.retrieval.source.DuraStoreStitchingRetrievalSource;
import org.duracloud.snapshot.SnapshotException;
import org.duracloud.snapshot.db.ContentDirUtils;
import org.duracloud.snapshot.db.model.DuracloudEndPointConfig;
import org.duracloud.snapshot.db.model.Snapshot;
import org.duracloud.snapshot.service.SnapshotJobManagerConfig;
import org.duracloud.snapshot.service.SnapshotManager;
import org.duracloud.snapshot.service.impl.BatchJobBuilder;
import org.duracloud.snapshot.service.impl.SnapshotJobExecutionListener;
import org.duracloud.snapshot.service.impl.SnapshotJobParameterMarshaller;
import org.duracloud.snapshot.service.impl.SpaceItemReader;
import org.duracloud.snapshot.service.impl.SpaceItemWriter;
import org.duracloud.snapshot.service.impl.SpaceManifestDpnManifestVerifier;
import org.duracloud.snapshot.service.impl.StoreClientHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.factory.SimpleStepFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;

@Component
public class SnapshotJobBuilder
implements BatchJobBuilder<Snapshot> {
    private static Logger log = LoggerFactory.getLogger(SnapshotJobBuilder.class);
    private static final String MANIFEST_SHA256_TXT_FILE_NAME = "manifest-sha256.txt";
    private static final String MANIFEST_MD5_TXT_FILE_NAME = "manifest-md5.txt";
    private SnapshotJobExecutionListener jobListener;
    private JobRepository jobRepository;
    private PlatformTransactionManager transactionManager;
    private TaskExecutor taskExecutor;
    private SnapshotManager snapshotManager;
    private StoreClientHelper storeClientHelper;

    @Autowired
    public SnapshotJobBuilder(SnapshotJobExecutionListener jobListener, JobRepository jobRepository, PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, SnapshotManager snapshotManager, StoreClientHelper storeClientHelper) {
        this.jobListener = jobListener;
        this.jobRepository = jobRepository;
        this.transactionManager = transactionManager;
        this.taskExecutor = taskExecutor;
        this.snapshotManager = snapshotManager;
        this.storeClientHelper = storeClientHelper;
    }

    @Override
    public Job buildJob(Snapshot snapshot, SnapshotJobManagerConfig config) throws SnapshotException {
        Job job;
        try {
            DuracloudEndPointConfig source = snapshot.getSource();
            ContentStore contentStore = this.storeClientHelper.create(source, config.getDuracloudUsername(), config.getDuracloudPassword());
            ArrayList<String> spaces = new ArrayList<String>();
            spaces.add(source.getSpaceId());
            DuraStoreStitchingRetrievalSource retrievalSource = new DuraStoreStitchingRetrievalSource(contentStore, spaces, false);
            SpaceItemReader itemReader = new SpaceItemReader(retrievalSource);
            File contentDir = new File(ContentDirUtils.getDestinationPath(snapshot.getName(), config.getContentRootDir()));
            if (!contentDir.exists()) {
                contentDir.mkdirs();
            }
            BufferedWriter propsWriter = this.createWriter(contentDir, "content-properties.json");
            File md5File = new File(contentDir, MANIFEST_MD5_TXT_FILE_NAME);
            BufferedWriter md5Writer = this.createWriter(contentDir, MANIFEST_MD5_TXT_FILE_NAME);
            BufferedWriter sha256Writer = this.createWriter(contentDir, MANIFEST_SHA256_TXT_FILE_NAME);
            SpaceManifestDpnManifestVerifier verifier = new SpaceManifestDpnManifestVerifier(md5File, new StitchedManifestGenerator(contentStore), source.getSpaceId());
            SpaceItemWriter itemWriter = new SpaceItemWriter(snapshot, retrievalSource, contentDir, new LoggingOutputWriter(), propsWriter, md5Writer, sha256Writer, this.snapshotManager, verifier);
            SimpleStepFactoryBean<ContentItem, ContentItem> stepFactory = new SimpleStepFactoryBean<ContentItem, ContentItem>();
            stepFactory.setJobRepository(this.jobRepository);
            stepFactory.setTransactionManager(this.transactionManager);
            stepFactory.setBeanName("step1");
            stepFactory.setItemReader(itemReader);
            stepFactory.setItemWriter(itemWriter);
            stepFactory.setCommitInterval(1);
            stepFactory.setThrottleLimit(20);
            stepFactory.setTaskExecutor(this.taskExecutor);
            Step step = stepFactory.getObject();
            JobBuilderFactory jobBuilderFactory = new JobBuilderFactory(this.jobRepository);
            JobBuilder jobBuilder = jobBuilderFactory.get("snapshot");
            SimpleJobBuilder simpleJobBuilder = jobBuilder.start(step);
            simpleJobBuilder.listener(this.jobListener);
            job = simpleJobBuilder.build();
            log.debug("build job {}", (Object)job);
        }
        catch (Exception e) {
            log.error("Error creating job: {}", (Object)e.getMessage(), (Object)e);
            throw new SnapshotException(e.getMessage(), e);
        }
        return job;
    }

    @Override
    public JobParameters buildIdentifyingJobParameters(Snapshot snapshot) {
        Map<String, JobParameter> map = this.createIdentifyingJobParameters(snapshot);
        JobParameters params = new JobParameters(map);
        return params;
    }

    @Override
    public JobParameters buildJobParameters(Snapshot snapshot) {
        return this.buildIdentifyingJobParameters(snapshot);
    }

    private Map<String, JobParameter> createIdentifyingJobParameters(Snapshot snapshot) {
        return SnapshotJobParameterMarshaller.marshal(snapshot);
    }

    private BufferedWriter createWriter(File contentDir, String file) throws IOException {
        Path path = this.getPath(contentDir, file);
        return this.createWriter(path);
    }

    private BufferedWriter createWriter(Path path) throws IOException {
        BufferedWriter propsWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);
        return propsWriter;
    }

    private Path getPath(File contentDir, String filename) {
        return ContentDirUtils.getPath(contentDir, filename);
    }
}

