/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.io.File;
import java.util.List;
import org.duracloud.client.ContentStore;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.domain.Space;
import org.duracloud.error.ContentStoreException;
import org.duracloud.error.NotFoundException;
import org.duracloud.snapshot.dto.RestoreStatus;
import org.duracloud.snapshot.service.RestoreManager;
import org.duracloud.snapshot.service.impl.StepExecutionSupport;
import org.duracloud.sync.endpoint.MonitoredFile;
import org.duracloud.sync.endpoint.SyncEndpoint;
import org.duracloud.sync.endpoint.SyncResultType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.item.ItemWriter;
import org.springframework.util.CollectionUtils;

public class SyncWriter
extends StepExecutionSupport
implements ItemWriter<File>,
ItemWriteListener<File> {
    private static Logger log = LoggerFactory.getLogger(SyncWriter.class);
    private SyncEndpoint endpoint;
    private File watchDir;
    private ContentStore contentStore;
    private String destinationSpaceId;
    private RestoreManager restoreManager;
    private String restorationId;

    public SyncWriter(String restorationId, File watchDir, SyncEndpoint endpoint, ContentStore contentStore, String destinationSpaceId, RestoreManager restoreManager) {
        this.endpoint = endpoint;
        this.watchDir = watchDir;
        this.contentStore = contentStore;
        this.destinationSpaceId = destinationSpaceId;
        this.restoreManager = restoreManager;
        this.restorationId = restorationId;
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        ExitStatus status = stepExecution.getExitStatus();
        List<String> errors = this.getErrors();
        if (errors.isEmpty()) {
            try {
                RestoreStatus newStatus = RestoreStatus.TRANSFER_TO_DURACLOUD_COMPLETE;
                this.restoreManager.transitionRestoreStatus(this.restorationId, newStatus, "");
                this.restoreFile(new File(this.watchDir.getParentFile(), ".collection-snapshot.properties"), this.watchDir.getParentFile());
                return status.and(ExitStatus.COMPLETED);
            }
            catch (Exception e) {
                String message = "failed to transition restore status: " + e.getMessage();
                log.error(message, e);
                return status.and(ExitStatus.FAILED).addExitDescription(message);
            }
        }
        status = status.and(ExitStatus.FAILED);
        status.addExitDescription("Transfer to DuraCloud failed: " + errors.size() + " items failed.");
        for (String error : errors) {
            status.addExitDescription(error);
        }
        return status;
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
        super.beforeStep(stepExecution);
        try {
            RestoreStatus newStatus = RestoreStatus.TRANSFERRING_TO_DURACLOUD;
            this.restoreManager.transitionRestoreStatus(this.restorationId, newStatus, "");
            Space space = this.contentStore.getSpace(this.destinationSpaceId, null, 1L, null);
            if (!CollectionUtils.isEmpty(space.getContentIds())) {
                stepExecution.addFailureException(new RuntimeException("destination space " + this.destinationSpaceId + " must be empty to receive restored content"));
            }
        }
        catch (NotFoundException ex) {
            try {
                this.contentStore.createSpace(this.destinationSpaceId);
            }
            catch (ContentStoreException e) {
                this.addError(ex.getMessage());
                stepExecution.addFailureException(e);
            }
        }
        catch (Exception ex) {
            this.addError(ex.getMessage());
            stepExecution.addFailureException(ex);
        }
    }

    @Override
    public void beforeWrite(List<? extends File> items) {
    }

    @Override
    public void write(List<? extends File> items) throws Exception {
        log.info("starting to write {} file(s) to duracloud", (Object)items.size());
        for (File file : items) {
            this.restoreFile(file, this.watchDir);
        }
    }

    private void restoreFile(final File file, final File watchDir) throws Exception {
        try {
            new Retrier().execute(new Retriable(){

                @Override
                public Object retry() throws Exception {
                    MonitoredFile monitoredFile = new MonitoredFile(file);
                    SyncResultType result = SyncWriter.this.endpoint.syncFileAndReturnDetailedResult(monitoredFile, watchDir);
                    if (result.equals((Object)SyncResultType.FAILED)) {
                        String message = "Failed to upload " + file.getAbsolutePath() + " after uploading " + monitoredFile.getStreamBytesRead() + " of " + file.length() + " bytes.";
                        throw new Exception(message);
                    }
                    log.info("successfully uploaded {}: result = {}", (Object)file.getAbsolutePath(), (Object)result);
                    return result;
                }
            });
        }
        catch (Exception ex) {
            this.addError(ex.getMessage());
        }
    }

    @Override
    public void afterWrite(List<? extends File> items) {
        this.addToItemsRead(items.size());
    }

    @Override
    public void onWriteError(Exception ex, List<? extends File> items) {
        log.error("Error writing item(s): " + items.toString(), ex);
    }
}

