/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.step.item;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.listener.MulticasterBatchListener;
import org.springframework.batch.core.step.item.Chunk;
import org.springframework.batch.core.step.item.ChunkProcessor;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.RepeatStatus;

public class JsrChunkProcessor<I, O>
implements ChunkProcessor<I> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private ItemReader<? extends I> itemReader;
    private final MulticasterBatchListener<I, O> listener = new MulticasterBatchListener();
    private RepeatOperations repeatTemplate;
    private ItemProcessor<? super I, ? extends O> itemProcessor;
    private ItemWriter<? super O> itemWriter;

    public JsrChunkProcessor() {
        this(null, null, null, null);
    }

    public JsrChunkProcessor(ItemReader<? extends I> reader, ItemProcessor<? super I, ? extends O> processor, ItemWriter<? super O> writer, RepeatOperations repeatTemplate) {
        this.itemReader = reader;
        this.itemProcessor = processor;
        this.itemWriter = writer;
        this.repeatTemplate = repeatTemplate;
    }

    protected MulticasterBatchListener<I, O> getListener() {
        return this.listener;
    }

    @Override
    public void process(final StepContribution contribution, final Chunk<I> chunk) throws Exception {
        final AtomicInteger filterCount = new AtomicInteger(0);
        final Chunk output = new Chunk();
        this.repeatTemplate.iterate(new RepeatCallback(){

            @Override
            public RepeatStatus doInIteration(RepeatContext context) throws Exception {
                Object item = JsrChunkProcessor.this.provide(contribution, chunk);
                if (item == null) {
                    return RepeatStatus.FINISHED;
                }
                contribution.incrementReadCount();
                Object processedItem = JsrChunkProcessor.this.transform(contribution, item);
                if (processedItem == null) {
                    filterCount.incrementAndGet();
                } else {
                    output.add(processedItem);
                }
                return RepeatStatus.CONTINUABLE;
            }
        });
        contribution.incrementFilterCount(filterCount.get());
        if (output.size() > 0) {
            this.persist(contribution, output);
        }
    }

    public void setListeners(List<? extends StepListener> listeners) {
        for (StepListener stepListener : listeners) {
            this.registerListener(stepListener);
        }
    }

    public void registerListener(StepListener listener) {
        this.listener.register(listener);
    }

    protected I provide(StepContribution contribution, Chunk<I> chunk) throws Exception {
        return this.doProvide(contribution, chunk);
    }

    protected final I doProvide(StepContribution contribution, Chunk<I> chunk) throws Exception {
        try {
            this.listener.beforeRead();
            I item = this.itemReader.read();
            if (item != null) {
                this.listener.afterRead(item);
            } else {
                chunk.setEnd();
            }
            return item;
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage() + " : " + e.getClass().getName());
            this.listener.onReadError(e);
            throw e;
        }
    }

    protected O transform(StepContribution contribution, I item) throws Exception {
        if (this.itemProcessor == null) {
            I result = item;
            return (O)result;
        }
        return this.doTransform(item);
    }

    protected final O doTransform(I item) throws Exception {
        try {
            this.listener.beforeProcess(item);
            O result = this.itemProcessor.process(item);
            this.listener.afterProcess(item, result);
            return result;
        }
        catch (Exception e) {
            this.listener.onProcessError(item, e);
            throw e;
        }
    }

    protected void persist(StepContribution contribution, Chunk<O> chunk) throws Exception {
        this.doPersist(contribution, chunk);
        contribution.incrementWriteCount(chunk.getItems().size());
    }

    protected final void doPersist(StepContribution contribution, Chunk<O> chunk) throws Exception {
        try {
            List<O> items = chunk.getItems();
            this.listener.beforeWrite(items);
            this.itemWriter.write(items);
            this.listener.afterWrite(items);
        }
        catch (Exception e) {
            this.listener.onWriteError(e, chunk.getItems());
            throw e;
        }
    }
}

