/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.util.Assert;

public class JpaItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(JpaItemWriter.class);
    private EntityManagerFactory entityManagerFactory;

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.entityManagerFactory, "An EntityManagerFactory is required");
    }

    @Override
    public void write(List<? extends T> items) {
        EntityManager entityManager = EntityManagerFactoryUtils.getTransactionalEntityManager(this.entityManagerFactory);
        if (entityManager == null) {
            throw new DataAccessResourceFailureException("Unable to obtain a transactional EntityManager");
        }
        this.doWrite(entityManager, items);
        entityManager.flush();
    }

    protected void doWrite(EntityManager entityManager, List<? extends T> items) {
        if (logger.isDebugEnabled()) {
            logger.debug("Writing to JPA with " + items.size() + " items.");
        }
        if (!items.isEmpty()) {
            long mergeCount = 0L;
            for (T item : items) {
                if (entityManager.contains(item)) continue;
                entityManager.merge(item);
                ++mergeCount;
            }
            if (logger.isDebugEnabled()) {
                logger.debug(mergeCount + " entities merged.");
                logger.debug((long)items.size() - mergeCount + " entities found in persistence context.");
            }
        }
    }
}

