/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import org.springframework.util.Assert;

public class Range<T extends Comparable<T>> {
    private final T lowerBound;
    private final T upperBound;
    private final boolean lowerInclusive;
    private final boolean upperInclusive;

    public Range(T lowerBound, T upperBound) {
        this(lowerBound, upperBound, true, true);
    }

    public Range(T lowerBound, T upperBound, boolean lowerInclusive, boolean upperInclusive) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.lowerInclusive = lowerInclusive;
        this.upperInclusive = upperInclusive;
    }

    public T getLowerBound() {
        return this.lowerBound;
    }

    public T getUpperBound() {
        return this.upperBound;
    }

    public boolean contains(T value) {
        boolean greaterThanLowerBound;
        Assert.notNull(value, "Reference value must not be null!");
        boolean bl = this.lowerBound == null ? true : (this.lowerInclusive ? this.lowerBound.compareTo(value) <= 0 : (greaterThanLowerBound = this.lowerBound.compareTo(value) < 0));
        boolean lessThanUpperBound = this.upperBound == null ? true : (this.upperInclusive ? this.upperBound.compareTo(value) >= 0 : this.upperBound.compareTo(value) > 0);
        return greaterThanLowerBound && lessThanUpperBound;
    }
}

