/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics.internal.cloudwatch.provider.transform;

import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.internal.cloudwatch.provider.transform.DynamoDBDimensions;
import com.amazonaws.metrics.internal.cloudwatch.spi.Dimensions;
import com.amazonaws.metrics.internal.cloudwatch.spi.RequestMetricTransformer;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.amazonaws.services.dynamodbv2.metrics.DynamoDBRequestMetric;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.apache.http.annotation.ThreadSafe;

@ThreadSafe
public class DynamoDBRequestMetricTransformer
implements RequestMetricTransformer {
    @Override
    public List<MetricDatum> toMetricData(MetricType metricType, Request<?> request, Response<?> response) {
        try {
            return this.toMetricData0(metricType, request, response);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            LogFactory.getLog(this.getClass()).debug("", e.getCause());
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).debug("", e);
        }
        return null;
    }

    private List<MetricDatum> toMetricData0(MetricType metricType, Request<?> req, Response<?> response) throws SecurityException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (!(metricType instanceof DynamoDBRequestMetric)) {
            return null;
        }
        DynamoDBRequestMetric predefined = (DynamoDBRequestMetric)metricType;
        switch (predefined) {
            case DynamoDBConsumedCapacity: {
                if (response == null) {
                    return Collections.emptyList();
                }
                Object awsResponse = response.getAwsResponse();
                Method method = awsResponse.getClass().getMethod("getConsumedCapacity", new Class[0]);
                Object value = method.invoke(awsResponse, new Object[0]);
                if (!(value instanceof ConsumedCapacity)) {
                    return Collections.emptyList();
                }
                ConsumedCapacity consumedCapacity = (ConsumedCapacity)value;
                Double units = consumedCapacity.getCapacityUnits();
                if (units == null) {
                    return Collections.emptyList();
                }
                String tableName = consumedCapacity.getTableName();
                ArrayList<Dimension> dims = new ArrayList<Dimension>();
                dims.add(new Dimension().withName(Dimensions.MetricType.name()).withValue(metricType.name()));
                dims.add(new Dimension().withName(Dimensions.RequestType.name()).withValue(this.requestType(req)));
                dims.add(new Dimension().withName(DynamoDBDimensions.TableName.name()).withValue(tableName));
                MetricDatum datum = new MetricDatum().withMetricName(req.getServiceName()).withDimensions(dims).withUnit(StandardUnit.Count).withValue(units);
                return Collections.singletonList(datum);
            }
        }
        return Collections.emptyList();
    }

    private String requestType(Request<?> req) {
        return req.getOriginalRequest().getClass().getSimpleName();
    }
}

