/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codedeploy.model.Diagnostics;
import com.amazonaws.util.json.JSONWriter;

public class DiagnosticsJsonMarshaller {
    private static DiagnosticsJsonMarshaller instance;

    public void marshall(Diagnostics diagnostics, JSONWriter jsonWriter) {
        if (diagnostics == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (diagnostics.getErrorCode() != null) {
                jsonWriter.key("errorCode").value(diagnostics.getErrorCode());
            }
            if (diagnostics.getScriptName() != null) {
                jsonWriter.key("scriptName").value(diagnostics.getScriptName());
            }
            if (diagnostics.getMessage() != null) {
                jsonWriter.key("message").value(diagnostics.getMessage());
            }
            if (diagnostics.getLogTail() != null) {
                jsonWriter.key("logTail").value(diagnostics.getLogTail());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DiagnosticsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DiagnosticsJsonMarshaller();
        }
        return instance;
    }
}

