/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.directconnect.model.CreateInterconnectRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateInterconnectRequestMarshaller
implements Marshaller<Request<CreateInterconnectRequest>, CreateInterconnectRequest> {
    @Override
    public Request<CreateInterconnectRequest> marshall(CreateInterconnectRequest createInterconnectRequest) {
        if (createInterconnectRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateInterconnectRequest> request = new DefaultRequest<CreateInterconnectRequest>(createInterconnectRequest, "AmazonDirectConnect");
        String target = "OvertureService.CreateInterconnect";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createInterconnectRequest.getInterconnectName() != null) {
                jsonWriter.key("interconnectName").value(createInterconnectRequest.getInterconnectName());
            }
            if (createInterconnectRequest.getBandwidth() != null) {
                jsonWriter.key("bandwidth").value(createInterconnectRequest.getBandwidth());
            }
            if (createInterconnectRequest.getLocation() != null) {
                jsonWriter.key("location").value(createInterconnectRequest.getLocation());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

