/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.directory.model.RadiusAuthenticationProtocol;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RadiusSettings
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<String> radiusServers;
    private Integer radiusPort;
    private Integer radiusTimeout;
    private Integer radiusRetries;
    private String sharedSecret;
    private String authenticationProtocol;
    private String displayLabel;
    private Boolean useSameUsername;

    public List<String> getRadiusServers() {
        if (this.radiusServers == null) {
            this.radiusServers = new ListWithAutoConstructFlag();
            this.radiusServers.setAutoConstruct(true);
        }
        return this.radiusServers;
    }

    public void setRadiusServers(Collection<String> radiusServers) {
        if (radiusServers == null) {
            this.radiusServers = null;
            return;
        }
        ListWithAutoConstructFlag radiusServersCopy = new ListWithAutoConstructFlag(radiusServers.size());
        radiusServersCopy.addAll(radiusServers);
        this.radiusServers = radiusServersCopy;
    }

    public RadiusSettings withRadiusServers(String ... radiusServers) {
        if (this.getRadiusServers() == null) {
            this.setRadiusServers(new ArrayList<String>(radiusServers.length));
        }
        for (String value : radiusServers) {
            this.getRadiusServers().add(value);
        }
        return this;
    }

    public RadiusSettings withRadiusServers(Collection<String> radiusServers) {
        if (radiusServers == null) {
            this.radiusServers = null;
        } else {
            ListWithAutoConstructFlag radiusServersCopy = new ListWithAutoConstructFlag(radiusServers.size());
            radiusServersCopy.addAll(radiusServers);
            this.radiusServers = radiusServersCopy;
        }
        return this;
    }

    public Integer getRadiusPort() {
        return this.radiusPort;
    }

    public void setRadiusPort(Integer radiusPort) {
        this.radiusPort = radiusPort;
    }

    public RadiusSettings withRadiusPort(Integer radiusPort) {
        this.radiusPort = radiusPort;
        return this;
    }

    public Integer getRadiusTimeout() {
        return this.radiusTimeout;
    }

    public void setRadiusTimeout(Integer radiusTimeout) {
        this.radiusTimeout = radiusTimeout;
    }

    public RadiusSettings withRadiusTimeout(Integer radiusTimeout) {
        this.radiusTimeout = radiusTimeout;
        return this;
    }

    public Integer getRadiusRetries() {
        return this.radiusRetries;
    }

    public void setRadiusRetries(Integer radiusRetries) {
        this.radiusRetries = radiusRetries;
    }

    public RadiusSettings withRadiusRetries(Integer radiusRetries) {
        this.radiusRetries = radiusRetries;
        return this;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    public RadiusSettings withSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
        return this;
    }

    public String getAuthenticationProtocol() {
        return this.authenticationProtocol;
    }

    public void setAuthenticationProtocol(String authenticationProtocol) {
        this.authenticationProtocol = authenticationProtocol;
    }

    public RadiusSettings withAuthenticationProtocol(String authenticationProtocol) {
        this.authenticationProtocol = authenticationProtocol;
        return this;
    }

    public void setAuthenticationProtocol(RadiusAuthenticationProtocol authenticationProtocol) {
        this.authenticationProtocol = authenticationProtocol.toString();
    }

    public RadiusSettings withAuthenticationProtocol(RadiusAuthenticationProtocol authenticationProtocol) {
        this.authenticationProtocol = authenticationProtocol.toString();
        return this;
    }

    public String getDisplayLabel() {
        return this.displayLabel;
    }

    public void setDisplayLabel(String displayLabel) {
        this.displayLabel = displayLabel;
    }

    public RadiusSettings withDisplayLabel(String displayLabel) {
        this.displayLabel = displayLabel;
        return this;
    }

    public Boolean isUseSameUsername() {
        return this.useSameUsername;
    }

    public void setUseSameUsername(Boolean useSameUsername) {
        this.useSameUsername = useSameUsername;
    }

    public RadiusSettings withUseSameUsername(Boolean useSameUsername) {
        this.useSameUsername = useSameUsername;
        return this;
    }

    public Boolean getUseSameUsername() {
        return this.useSameUsername;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRadiusServers() != null) {
            sb.append("RadiusServers: " + this.getRadiusServers() + ",");
        }
        if (this.getRadiusPort() != null) {
            sb.append("RadiusPort: " + this.getRadiusPort() + ",");
        }
        if (this.getRadiusTimeout() != null) {
            sb.append("RadiusTimeout: " + this.getRadiusTimeout() + ",");
        }
        if (this.getRadiusRetries() != null) {
            sb.append("RadiusRetries: " + this.getRadiusRetries() + ",");
        }
        if (this.getSharedSecret() != null) {
            sb.append("SharedSecret: " + this.getSharedSecret() + ",");
        }
        if (this.getAuthenticationProtocol() != null) {
            sb.append("AuthenticationProtocol: " + this.getAuthenticationProtocol() + ",");
        }
        if (this.getDisplayLabel() != null) {
            sb.append("DisplayLabel: " + this.getDisplayLabel() + ",");
        }
        if (this.isUseSameUsername() != null) {
            sb.append("UseSameUsername: " + this.isUseSameUsername());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRadiusServers() == null ? 0 : this.getRadiusServers().hashCode());
        hashCode = 31 * hashCode + (this.getRadiusPort() == null ? 0 : this.getRadiusPort().hashCode());
        hashCode = 31 * hashCode + (this.getRadiusTimeout() == null ? 0 : this.getRadiusTimeout().hashCode());
        hashCode = 31 * hashCode + (this.getRadiusRetries() == null ? 0 : this.getRadiusRetries().hashCode());
        hashCode = 31 * hashCode + (this.getSharedSecret() == null ? 0 : this.getSharedSecret().hashCode());
        hashCode = 31 * hashCode + (this.getAuthenticationProtocol() == null ? 0 : this.getAuthenticationProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayLabel() == null ? 0 : this.getDisplayLabel().hashCode());
        hashCode = 31 * hashCode + (this.isUseSameUsername() == null ? 0 : this.isUseSameUsername().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RadiusSettings)) {
            return false;
        }
        RadiusSettings other = (RadiusSettings)obj;
        if (other.getRadiusServers() == null ^ this.getRadiusServers() == null) {
            return false;
        }
        if (other.getRadiusServers() != null && !other.getRadiusServers().equals(this.getRadiusServers())) {
            return false;
        }
        if (other.getRadiusPort() == null ^ this.getRadiusPort() == null) {
            return false;
        }
        if (other.getRadiusPort() != null && !other.getRadiusPort().equals(this.getRadiusPort())) {
            return false;
        }
        if (other.getRadiusTimeout() == null ^ this.getRadiusTimeout() == null) {
            return false;
        }
        if (other.getRadiusTimeout() != null && !other.getRadiusTimeout().equals(this.getRadiusTimeout())) {
            return false;
        }
        if (other.getRadiusRetries() == null ^ this.getRadiusRetries() == null) {
            return false;
        }
        if (other.getRadiusRetries() != null && !other.getRadiusRetries().equals(this.getRadiusRetries())) {
            return false;
        }
        if (other.getSharedSecret() == null ^ this.getSharedSecret() == null) {
            return false;
        }
        if (other.getSharedSecret() != null && !other.getSharedSecret().equals(this.getSharedSecret())) {
            return false;
        }
        if (other.getAuthenticationProtocol() == null ^ this.getAuthenticationProtocol() == null) {
            return false;
        }
        if (other.getAuthenticationProtocol() != null && !other.getAuthenticationProtocol().equals(this.getAuthenticationProtocol())) {
            return false;
        }
        if (other.getDisplayLabel() == null ^ this.getDisplayLabel() == null) {
            return false;
        }
        if (other.getDisplayLabel() != null && !other.getDisplayLabel().equals(this.getDisplayLabel())) {
            return false;
        }
        if (other.isUseSameUsername() == null ^ this.isUseSameUsername() == null) {
            return false;
        }
        return other.isUseSameUsername() == null || other.isUseSameUsername().equals(this.isUseSameUsername());
    }

    public RadiusSettings clone() {
        try {
            return (RadiusSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

