/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.directory.model.EnableSsoRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class EnableSsoRequestMarshaller
implements Marshaller<Request<EnableSsoRequest>, EnableSsoRequest> {
    @Override
    public Request<EnableSsoRequest> marshall(EnableSsoRequest enableSsoRequest) {
        if (enableSsoRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<EnableSsoRequest> request = new DefaultRequest<EnableSsoRequest>(enableSsoRequest, "AWSDirectoryService");
        String target = "DirectoryService_20150416.EnableSso";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (enableSsoRequest.getDirectoryId() != null) {
                jsonWriter.key("DirectoryId").value(enableSsoRequest.getDirectoryId());
            }
            if (enableSsoRequest.getUserName() != null) {
                jsonWriter.key("UserName").value(enableSsoRequest.getUserName());
            }
            if (enableSsoRequest.getPassword() != null) {
                jsonWriter.key("Password").value(enableSsoRequest.getPassword());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

