/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribePrefixListsRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribePrefixListsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DescribePrefixListsRequest> {
    private ListWithAutoConstructFlag<String> prefixListIds;
    private ListWithAutoConstructFlag<Filter> filters;
    private Integer maxResults;
    private String nextToken;

    public List<String> getPrefixListIds() {
        if (this.prefixListIds == null) {
            this.prefixListIds = new ListWithAutoConstructFlag();
            this.prefixListIds.setAutoConstruct(true);
        }
        return this.prefixListIds;
    }

    public void setPrefixListIds(Collection<String> prefixListIds) {
        if (prefixListIds == null) {
            this.prefixListIds = null;
            return;
        }
        ListWithAutoConstructFlag prefixListIdsCopy = new ListWithAutoConstructFlag(prefixListIds.size());
        prefixListIdsCopy.addAll(prefixListIds);
        this.prefixListIds = prefixListIdsCopy;
    }

    public DescribePrefixListsRequest withPrefixListIds(String ... prefixListIds) {
        if (this.getPrefixListIds() == null) {
            this.setPrefixListIds(new ArrayList<String>(prefixListIds.length));
        }
        for (String value : prefixListIds) {
            this.getPrefixListIds().add(value);
        }
        return this;
    }

    public DescribePrefixListsRequest withPrefixListIds(Collection<String> prefixListIds) {
        if (prefixListIds == null) {
            this.prefixListIds = null;
        } else {
            ListWithAutoConstructFlag prefixListIdsCopy = new ListWithAutoConstructFlag(prefixListIds.size());
            prefixListIdsCopy.addAll(prefixListIds);
            this.prefixListIds = prefixListIdsCopy;
        }
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ListWithAutoConstructFlag();
            this.filters.setAutoConstruct(true);
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribePrefixListsRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribePrefixListsRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public DescribePrefixListsRequest withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribePrefixListsRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    @Override
    public Request<DescribePrefixListsRequest> getDryRunRequest() {
        Request<DescribePrefixListsRequest> request = new DescribePrefixListsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPrefixListIds() != null) {
            sb.append("PrefixListIds: " + this.getPrefixListIds() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters() + ",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: " + this.getMaxResults() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPrefixListIds() == null ? 0 : this.getPrefixListIds().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePrefixListsRequest)) {
            return false;
        }
        DescribePrefixListsRequest other = (DescribePrefixListsRequest)obj;
        if (other.getPrefixListIds() == null ^ this.getPrefixListIds() == null) {
            return false;
        }
        if (other.getPrefixListIds() != null && !other.getPrefixListIds().equals(this.getPrefixListIds())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    @Override
    public DescribePrefixListsRequest clone() {
        return (DescribePrefixListsRequest)super.clone();
    }
}

