/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.ArchitectureValues;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.ShutdownBehavior;
import com.amazonaws.services.ec2.model.UserData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ImportInstanceLaunchSpecification
implements Serializable,
Cloneable {
    private String architecture;
    private ListWithAutoConstructFlag<String> groupNames;
    private ListWithAutoConstructFlag<String> groupIds;
    private String additionalInfo;
    private UserData userData;
    private String instanceType;
    private Placement placement;
    private Boolean monitoring;
    private String subnetId;
    private String instanceInitiatedShutdownBehavior;
    private String privateIpAddress;

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public ImportInstanceLaunchSpecification withArchitecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    public void setArchitecture(ArchitectureValues architecture) {
        this.architecture = architecture.toString();
    }

    public ImportInstanceLaunchSpecification withArchitecture(ArchitectureValues architecture) {
        this.architecture = architecture.toString();
        return this;
    }

    public List<String> getGroupNames() {
        if (this.groupNames == null) {
            this.groupNames = new ListWithAutoConstructFlag();
            this.groupNames.setAutoConstruct(true);
        }
        return this.groupNames;
    }

    public void setGroupNames(Collection<String> groupNames) {
        if (groupNames == null) {
            this.groupNames = null;
            return;
        }
        ListWithAutoConstructFlag groupNamesCopy = new ListWithAutoConstructFlag(groupNames.size());
        groupNamesCopy.addAll(groupNames);
        this.groupNames = groupNamesCopy;
    }

    public ImportInstanceLaunchSpecification withGroupNames(String ... groupNames) {
        if (this.getGroupNames() == null) {
            this.setGroupNames(new ArrayList<String>(groupNames.length));
        }
        for (String value : groupNames) {
            this.getGroupNames().add(value);
        }
        return this;
    }

    public ImportInstanceLaunchSpecification withGroupNames(Collection<String> groupNames) {
        if (groupNames == null) {
            this.groupNames = null;
        } else {
            ListWithAutoConstructFlag groupNamesCopy = new ListWithAutoConstructFlag(groupNames.size());
            groupNamesCopy.addAll(groupNames);
            this.groupNames = groupNamesCopy;
        }
        return this;
    }

    public List<String> getGroupIds() {
        if (this.groupIds == null) {
            this.groupIds = new ListWithAutoConstructFlag();
            this.groupIds.setAutoConstruct(true);
        }
        return this.groupIds;
    }

    public void setGroupIds(Collection<String> groupIds) {
        if (groupIds == null) {
            this.groupIds = null;
            return;
        }
        ListWithAutoConstructFlag groupIdsCopy = new ListWithAutoConstructFlag(groupIds.size());
        groupIdsCopy.addAll(groupIds);
        this.groupIds = groupIdsCopy;
    }

    public ImportInstanceLaunchSpecification withGroupIds(String ... groupIds) {
        if (this.getGroupIds() == null) {
            this.setGroupIds(new ArrayList<String>(groupIds.length));
        }
        for (String value : groupIds) {
            this.getGroupIds().add(value);
        }
        return this;
    }

    public ImportInstanceLaunchSpecification withGroupIds(Collection<String> groupIds) {
        if (groupIds == null) {
            this.groupIds = null;
        } else {
            ListWithAutoConstructFlag groupIdsCopy = new ListWithAutoConstructFlag(groupIds.size());
            groupIdsCopy.addAll(groupIds);
            this.groupIds = groupIdsCopy;
        }
        return this;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public ImportInstanceLaunchSpecification withAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
        return this;
    }

    public UserData getUserData() {
        return this.userData;
    }

    public void setUserData(UserData userData) {
        this.userData = userData;
    }

    public ImportInstanceLaunchSpecification withUserData(UserData userData) {
        this.userData = userData;
        return this;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public ImportInstanceLaunchSpecification withInstanceType(String instanceType) {
        this.instanceType = instanceType;
        return this;
    }

    public void setInstanceType(InstanceType instanceType) {
        this.instanceType = instanceType.toString();
    }

    public ImportInstanceLaunchSpecification withInstanceType(InstanceType instanceType) {
        this.instanceType = instanceType.toString();
        return this;
    }

    public Placement getPlacement() {
        return this.placement;
    }

    public void setPlacement(Placement placement) {
        this.placement = placement;
    }

    public ImportInstanceLaunchSpecification withPlacement(Placement placement) {
        this.placement = placement;
        return this;
    }

    public Boolean isMonitoring() {
        return this.monitoring;
    }

    public void setMonitoring(Boolean monitoring) {
        this.monitoring = monitoring;
    }

    public ImportInstanceLaunchSpecification withMonitoring(Boolean monitoring) {
        this.monitoring = monitoring;
        return this;
    }

    public Boolean getMonitoring() {
        return this.monitoring;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public ImportInstanceLaunchSpecification withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String getInstanceInitiatedShutdownBehavior() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
        this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
    }

    public ImportInstanceLaunchSpecification withInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
        this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        return this;
    }

    public void setInstanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
        this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior.toString();
    }

    public ImportInstanceLaunchSpecification withInstanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
        this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior.toString();
        return this;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public ImportInstanceLaunchSpecification withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArchitecture() != null) {
            sb.append("Architecture: " + this.getArchitecture() + ",");
        }
        if (this.getGroupNames() != null) {
            sb.append("GroupNames: " + this.getGroupNames() + ",");
        }
        if (this.getGroupIds() != null) {
            sb.append("GroupIds: " + this.getGroupIds() + ",");
        }
        if (this.getAdditionalInfo() != null) {
            sb.append("AdditionalInfo: " + this.getAdditionalInfo() + ",");
        }
        if (this.getUserData() != null) {
            sb.append("UserData: " + this.getUserData() + ",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: " + this.getInstanceType() + ",");
        }
        if (this.getPlacement() != null) {
            sb.append("Placement: " + this.getPlacement() + ",");
        }
        if (this.isMonitoring() != null) {
            sb.append("Monitoring: " + this.isMonitoring() + ",");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: " + this.getSubnetId() + ",");
        }
        if (this.getInstanceInitiatedShutdownBehavior() != null) {
            sb.append("InstanceInitiatedShutdownBehavior: " + this.getInstanceInitiatedShutdownBehavior() + ",");
        }
        if (this.getPrivateIpAddress() != null) {
            sb.append("PrivateIpAddress: " + this.getPrivateIpAddress());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArchitecture() == null ? 0 : this.getArchitecture().hashCode());
        hashCode = 31 * hashCode + (this.getGroupNames() == null ? 0 : this.getGroupNames().hashCode());
        hashCode = 31 * hashCode + (this.getGroupIds() == null ? 0 : this.getGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalInfo() == null ? 0 : this.getAdditionalInfo().hashCode());
        hashCode = 31 * hashCode + (this.getUserData() == null ? 0 : this.getUserData().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getPlacement() == null ? 0 : this.getPlacement().hashCode());
        hashCode = 31 * hashCode + (this.isMonitoring() == null ? 0 : this.isMonitoring().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceInitiatedShutdownBehavior() == null ? 0 : this.getInstanceInitiatedShutdownBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddress() == null ? 0 : this.getPrivateIpAddress().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceLaunchSpecification)) {
            return false;
        }
        ImportInstanceLaunchSpecification other = (ImportInstanceLaunchSpecification)obj;
        if (other.getArchitecture() == null ^ this.getArchitecture() == null) {
            return false;
        }
        if (other.getArchitecture() != null && !other.getArchitecture().equals(this.getArchitecture())) {
            return false;
        }
        if (other.getGroupNames() == null ^ this.getGroupNames() == null) {
            return false;
        }
        if (other.getGroupNames() != null && !other.getGroupNames().equals(this.getGroupNames())) {
            return false;
        }
        if (other.getGroupIds() == null ^ this.getGroupIds() == null) {
            return false;
        }
        if (other.getGroupIds() != null && !other.getGroupIds().equals(this.getGroupIds())) {
            return false;
        }
        if (other.getAdditionalInfo() == null ^ this.getAdditionalInfo() == null) {
            return false;
        }
        if (other.getAdditionalInfo() != null && !other.getAdditionalInfo().equals(this.getAdditionalInfo())) {
            return false;
        }
        if (other.getUserData() == null ^ this.getUserData() == null) {
            return false;
        }
        if (other.getUserData() != null && !other.getUserData().equals(this.getUserData())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getPlacement() == null ^ this.getPlacement() == null) {
            return false;
        }
        if (other.getPlacement() != null && !other.getPlacement().equals(this.getPlacement())) {
            return false;
        }
        if (other.isMonitoring() == null ^ this.isMonitoring() == null) {
            return false;
        }
        if (other.isMonitoring() != null && !other.isMonitoring().equals(this.isMonitoring())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getInstanceInitiatedShutdownBehavior() == null ^ this.getInstanceInitiatedShutdownBehavior() == null) {
            return false;
        }
        if (other.getInstanceInitiatedShutdownBehavior() != null && !other.getInstanceInitiatedShutdownBehavior().equals(this.getInstanceInitiatedShutdownBehavior())) {
            return false;
        }
        if (other.getPrivateIpAddress() == null ^ this.getPrivateIpAddress() == null) {
            return false;
        }
        return other.getPrivateIpAddress() == null || other.getPrivateIpAddress().equals(this.getPrivateIpAddress());
    }

    public ImportInstanceLaunchSpecification clone() {
        try {
            return (ImportInstanceLaunchSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

