/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DescribeMountTargetsRequestMarshaller
implements Marshaller<Request<DescribeMountTargetsRequest>, DescribeMountTargetsRequest> {
    @Override
    public Request<DescribeMountTargetsRequest> marshall(DescribeMountTargetsRequest describeMountTargetsRequest) {
        String mountTargetId;
        String fileSystemId;
        String marker;
        String maxItems;
        if (describeMountTargetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeMountTargetsRequest> request = new DefaultRequest<DescribeMountTargetsRequest>(describeMountTargetsRequest, "AmazonElasticFileSystem");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-02-01/mount-targets";
        request.setResourcePath(uriResourcePath);
        String string = maxItems = describeMountTargetsRequest.getMaxItems() == null ? null : StringUtils.fromInteger(describeMountTargetsRequest.getMaxItems());
        if (maxItems != null) {
            request.addParameter("MaxItems", maxItems);
        }
        String string2 = marker = describeMountTargetsRequest.getMarker() == null ? null : StringUtils.fromString(describeMountTargetsRequest.getMarker());
        if (marker != null) {
            request.addParameter("Marker", marker);
        }
        String string3 = fileSystemId = describeMountTargetsRequest.getFileSystemId() == null ? null : StringUtils.fromString(describeMountTargetsRequest.getFileSystemId());
        if (fileSystemId != null) {
            request.addParameter("FileSystemId", fileSystemId);
        }
        String string4 = mountTargetId = describeMountTargetsRequest.getMountTargetId() == null ? null : StringUtils.fromString(describeMountTargetsRequest.getMountTargetId());
        if (mountTargetId != null) {
            request.addParameter("MountTargetId", mountTargetId);
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

