/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesis.model.AddTagsToStreamRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Map;

public class AddTagsToStreamRequestMarshaller
implements Marshaller<Request<AddTagsToStreamRequest>, AddTagsToStreamRequest> {
    @Override
    public Request<AddTagsToStreamRequest> marshall(AddTagsToStreamRequest addTagsToStreamRequest) {
        if (addTagsToStreamRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddTagsToStreamRequest> request = new DefaultRequest<AddTagsToStreamRequest>(addTagsToStreamRequest, "AmazonKinesis");
        String target = "Kinesis_20131202.AddTagsToStream";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (addTagsToStreamRequest.getStreamName() != null) {
                jsonWriter.key("StreamName").value(addTagsToStreamRequest.getStreamName());
            }
            if (addTagsToStreamRequest.getTags() != null) {
                jsonWriter.key("Tags");
                jsonWriter.object();
                for (Map.Entry<String, String> tagsListValue : addTagsToStreamRequest.getTags().entrySet()) {
                    if (tagsListValue.getValue() == null) continue;
                    jsonWriter.key(tagsListValue.getKey());
                    jsonWriter.value(tagsListValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

