/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.Filter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeDBLogFilesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String dBInstanceIdentifier;
    private String filenameContains;
    private Long fileLastWritten;
    private Long fileSize;
    private ListWithAutoConstructFlag<Filter> filters;
    private Integer maxRecords;
    private String marker;

    public String getDBInstanceIdentifier() {
        return this.dBInstanceIdentifier;
    }

    public void setDBInstanceIdentifier(String dBInstanceIdentifier) {
        this.dBInstanceIdentifier = dBInstanceIdentifier;
    }

    public DescribeDBLogFilesRequest withDBInstanceIdentifier(String dBInstanceIdentifier) {
        this.dBInstanceIdentifier = dBInstanceIdentifier;
        return this;
    }

    public String getFilenameContains() {
        return this.filenameContains;
    }

    public void setFilenameContains(String filenameContains) {
        this.filenameContains = filenameContains;
    }

    public DescribeDBLogFilesRequest withFilenameContains(String filenameContains) {
        this.filenameContains = filenameContains;
        return this;
    }

    public Long getFileLastWritten() {
        return this.fileLastWritten;
    }

    public void setFileLastWritten(Long fileLastWritten) {
        this.fileLastWritten = fileLastWritten;
    }

    public DescribeDBLogFilesRequest withFileLastWritten(Long fileLastWritten) {
        this.fileLastWritten = fileLastWritten;
        return this;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public DescribeDBLogFilesRequest withFileSize(Long fileSize) {
        this.fileSize = fileSize;
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ListWithAutoConstructFlag();
            this.filters.setAutoConstruct(true);
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeDBLogFilesRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeDBLogFilesRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    public Integer getMaxRecords() {
        return this.maxRecords;
    }

    public void setMaxRecords(Integer maxRecords) {
        this.maxRecords = maxRecords;
    }

    public DescribeDBLogFilesRequest withMaxRecords(Integer maxRecords) {
        this.maxRecords = maxRecords;
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public DescribeDBLogFilesRequest withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDBInstanceIdentifier() != null) {
            sb.append("DBInstanceIdentifier: " + this.getDBInstanceIdentifier() + ",");
        }
        if (this.getFilenameContains() != null) {
            sb.append("FilenameContains: " + this.getFilenameContains() + ",");
        }
        if (this.getFileLastWritten() != null) {
            sb.append("FileLastWritten: " + this.getFileLastWritten() + ",");
        }
        if (this.getFileSize() != null) {
            sb.append("FileSize: " + this.getFileSize() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters() + ",");
        }
        if (this.getMaxRecords() != null) {
            sb.append("MaxRecords: " + this.getMaxRecords() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDBInstanceIdentifier() == null ? 0 : this.getDBInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getFilenameContains() == null ? 0 : this.getFilenameContains().hashCode());
        hashCode = 31 * hashCode + (this.getFileLastWritten() == null ? 0 : this.getFileLastWritten().hashCode());
        hashCode = 31 * hashCode + (this.getFileSize() == null ? 0 : this.getFileSize().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getMaxRecords() == null ? 0 : this.getMaxRecords().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBLogFilesRequest)) {
            return false;
        }
        DescribeDBLogFilesRequest other = (DescribeDBLogFilesRequest)obj;
        if (other.getDBInstanceIdentifier() == null ^ this.getDBInstanceIdentifier() == null) {
            return false;
        }
        if (other.getDBInstanceIdentifier() != null && !other.getDBInstanceIdentifier().equals(this.getDBInstanceIdentifier())) {
            return false;
        }
        if (other.getFilenameContains() == null ^ this.getFilenameContains() == null) {
            return false;
        }
        if (other.getFilenameContains() != null && !other.getFilenameContains().equals(this.getFilenameContains())) {
            return false;
        }
        if (other.getFileLastWritten() == null ^ this.getFileLastWritten() == null) {
            return false;
        }
        if (other.getFileLastWritten() != null && !other.getFileLastWritten().equals(this.getFileLastWritten())) {
            return false;
        }
        if (other.getFileSize() == null ^ this.getFileSize() == null) {
            return false;
        }
        if (other.getFileSize() != null && !other.getFileSize().equals(this.getFileSize())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getMaxRecords() == null ^ this.getMaxRecords() == null) {
            return false;
        }
        if (other.getMaxRecords() != null && !other.getMaxRecords().equals(this.getMaxRecords())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    @Override
    public DescribeDBLogFilesRequest clone() {
        return (DescribeDBLogFilesRequest)super.clone();
    }
}

