/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.AssociateVPCWithHostedZoneRequest;
import com.amazonaws.services.route53.model.VPC;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AssociateVPCWithHostedZoneRequestMarshaller
implements Marshaller<Request<AssociateVPCWithHostedZoneRequest>, AssociateVPCWithHostedZoneRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    @Override
    public Request<AssociateVPCWithHostedZoneRequest> marshall(AssociateVPCWithHostedZoneRequest associateVPCWithHostedZoneRequest) {
        VPC vPCVPC;
        if (associateVPCWithHostedZoneRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AssociateVPCWithHostedZoneRequest> request = new DefaultRequest<AssociateVPCWithHostedZoneRequest>(associateVPCWithHostedZoneRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("Id")) {
            String value;
            String name = DYNAMIC_QUERY_PARAMS.get("Id");
            String string = value = associateVPCWithHostedZoneRequest.getHostedZoneId() == null ? null : StringUtils.fromString(associateVPCWithHostedZoneRequest.getHostedZoneId());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Id}", associateVPCWithHostedZoneRequest.getHostedZoneId() == null ? "" : StringUtils.fromString(associateVPCWithHostedZoneRequest.getHostedZoneId()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter(stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
        xmlWriter.startElement("AssociateVPCWithHostedZoneRequest");
        if (associateVPCWithHostedZoneRequest != null && (vPCVPC = associateVPCWithHostedZoneRequest.getVPC()) != null) {
            xmlWriter.startElement("VPC");
            if (vPCVPC.getVPCRegion() != null) {
                xmlWriter.startElement("VPCRegion").value(vPCVPC.getVPCRegion()).endElement();
            }
            if (vPCVPC.getVPCId() != null) {
                xmlWriter.startElement("VPCId").value(vPCVPC.getVPCId()).endElement();
            }
            xmlWriter.endElement();
        }
        if (associateVPCWithHostedZoneRequest.getComment() != null) {
            xmlWriter.startElement("Comment").value(associateVPCWithHostedZoneRequest.getComment()).endElement();
        }
        xmlWriter.endElement();
        try {
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            request.addHeader("Content-Type", "application/xml");
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to marshall request to XML", e);
        }
        return request;
    }

    static {
        String path = "/2013-04-01/hostedzone/{Id}/associatevpc";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

