/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.ListResourceRecordSetsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ListResourceRecordSetsRequestMarshaller
implements Marshaller<Request<ListResourceRecordSetsRequest>, ListResourceRecordSetsRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    @Override
    public Request<ListResourceRecordSetsRequest> marshall(ListResourceRecordSetsRequest listResourceRecordSetsRequest) {
        String value;
        String name;
        if (listResourceRecordSetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListResourceRecordSetsRequest> request = new DefaultRequest<ListResourceRecordSetsRequest>(listResourceRecordSetsRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("Id")) {
            name = DYNAMIC_QUERY_PARAMS.get("Id");
            String string = value = listResourceRecordSetsRequest.getHostedZoneId() == null ? null : StringUtils.fromString(listResourceRecordSetsRequest.getHostedZoneId());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Id}", listResourceRecordSetsRequest.getHostedZoneId() == null ? "" : StringUtils.fromString(listResourceRecordSetsRequest.getHostedZoneId()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Name")) {
            name = DYNAMIC_QUERY_PARAMS.get("Name");
            String string = value = listResourceRecordSetsRequest.getStartRecordName() == null ? null : StringUtils.fromString(listResourceRecordSetsRequest.getStartRecordName());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Name}", listResourceRecordSetsRequest.getStartRecordName() == null ? "" : StringUtils.fromString(listResourceRecordSetsRequest.getStartRecordName()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Type")) {
            name = DYNAMIC_QUERY_PARAMS.get("Type");
            String string = value = listResourceRecordSetsRequest.getStartRecordType() == null ? null : StringUtils.fromString(listResourceRecordSetsRequest.getStartRecordType());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Type}", listResourceRecordSetsRequest.getStartRecordType() == null ? "" : StringUtils.fromString(listResourceRecordSetsRequest.getStartRecordType()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Identifier")) {
            name = DYNAMIC_QUERY_PARAMS.get("Identifier");
            String string = value = listResourceRecordSetsRequest.getStartRecordIdentifier() == null ? null : StringUtils.fromString(listResourceRecordSetsRequest.getStartRecordIdentifier());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Identifier}", listResourceRecordSetsRequest.getStartRecordIdentifier() == null ? "" : StringUtils.fromString(listResourceRecordSetsRequest.getStartRecordIdentifier()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("MaxItems")) {
            name = DYNAMIC_QUERY_PARAMS.get("MaxItems");
            String string = value = listResourceRecordSetsRequest.getMaxItems() == null ? null : StringUtils.fromString(listResourceRecordSetsRequest.getMaxItems());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{MaxItems}", listResourceRecordSetsRequest.getMaxItems() == null ? "" : StringUtils.fromString(listResourceRecordSetsRequest.getMaxItems()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        return request;
    }

    static {
        String path = "/2013-04-01/hostedzone/{Id}/rrset?type={Type}&name={Name}&identifier={Identifier}&maxitems={MaxItems}";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

