/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.DeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.UpdateCondition;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DeleteAttributesRequestMarshaller
implements Marshaller<Request<DeleteAttributesRequest>, DeleteAttributesRequest> {
    @Override
    public Request<DeleteAttributesRequest> marshall(DeleteAttributesRequest deleteAttributesRequest) {
        if (deleteAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteAttributesRequest> request = new DefaultRequest<DeleteAttributesRequest>(deleteAttributesRequest, "AmazonSimpleDB");
        request.addParameter("Action", "DeleteAttributes");
        request.addParameter("Version", "2009-04-15");
        if (deleteAttributesRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString(deleteAttributesRequest.getDomainName()));
        }
        if (deleteAttributesRequest.getItemName() != null) {
            request.addParameter("ItemName", StringUtils.fromString(deleteAttributesRequest.getItemName()));
        }
        List<Attribute> attributesList = deleteAttributesRequest.getAttributes();
        int attributesListIndex = 1;
        for (Attribute attributesListValue : attributesList) {
            Attribute attributeMember = attributesListValue;
            if (attributeMember != null) {
                if (attributeMember.getName() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".Name", StringUtils.fromString(attributeMember.getName()));
                }
                if (attributeMember.getAlternateNameEncoding() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".AlternateNameEncoding", StringUtils.fromString(attributeMember.getAlternateNameEncoding()));
                }
                if (attributeMember.getValue() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".Value", StringUtils.fromString(attributeMember.getValue()));
                }
                if (attributeMember.getAlternateValueEncoding() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".AlternateValueEncoding", StringUtils.fromString(attributeMember.getAlternateValueEncoding()));
                }
            }
            ++attributesListIndex;
        }
        UpdateCondition updateConditionExpected = deleteAttributesRequest.getExpected();
        if (updateConditionExpected != null) {
            if (updateConditionExpected.getName() != null) {
                request.addParameter("Expected.Name", StringUtils.fromString(updateConditionExpected.getName()));
            }
            if (updateConditionExpected.getValue() != null) {
                request.addParameter("Expected.Value", StringUtils.fromString(updateConditionExpected.getValue()));
            }
            if (updateConditionExpected.isExists() != null) {
                request.addParameter("Expected.Exists", StringUtils.fromBoolean(updateConditionExpected.isExists()));
            }
        }
        return request;
    }
}

