/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.generic.ActivityImplementationFactory;
import com.amazonaws.services.simpleworkflow.flow.worker.SynchronousActivityTaskPoller;
import com.amazonaws.services.simpleworkflow.model.ActivityTask;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActivityTaskPoller
extends SynchronousActivityTaskPoller {
    private static final Log log = LogFactory.getLog(ActivityTaskPoller.class);
    private ThreadPoolExecutor taskExecutorService;
    protected Semaphore pollSemaphore;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.error("Failure in thread " + t.getName(), e);
        }
    };

    public ActivityTaskPoller(AmazonSimpleWorkflow service, String domain, String pollTaskList, ActivityImplementationFactory activityImplementationFactory, ThreadPoolExecutor taskExecutorService) {
        super(service, domain, pollTaskList, activityImplementationFactory);
        this.setTaskExecutorService(taskExecutorService);
    }

    public ExecutorService getTaskExecutorService() {
        return this.taskExecutorService;
    }

    public void setTaskExecutorService(ThreadPoolExecutor taskExecutorService) {
        this.taskExecutorService = taskExecutorService;
        this.pollSemaphore = new Semaphore(taskExecutorService.getMaximumPoolSize());
    }

    @Override
    public boolean pollAndProcessSingleTask() throws Exception {
        boolean semaphoreNeedsRelease = false;
        try {
            if (this.pollSemaphore != null) {
                this.pollSemaphore.acquire();
            }
            semaphoreNeedsRelease = true;
            final ActivityTask task = this.poll();
            if (task == null) {
                return false;
            }
            semaphoreNeedsRelease = false;
            try {
                this.taskExecutorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            try {
                                ActivityTaskPoller.this.execute(task);
                            }
                            catch (Throwable ee) {
                                ActivityTaskPoller.this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), ActivityTaskPoller.this.wrapFailure(task, ee));
                                ActivityTaskPoller.this.pollSemaphore.release();
                            }
                        }
                        finally {
                            ActivityTaskPoller.this.pollSemaphore.release();
                        }
                    }
                });
            }
            catch (Exception e) {
                semaphoreNeedsRelease = true;
                throw e;
            }
            catch (Error e) {
                semaphoreNeedsRelease = true;
                throw e;
            }
        }
        finally {
            if (semaphoreNeedsRelease) {
                this.pollSemaphore.release();
            }
        }
        return true;
    }

    private Exception wrapFailure(ActivityTask task, Throwable failure) {
        WorkflowExecution execution = task.getWorkflowExecution();
        RuntimeException e2 = new RuntimeException("Failure taskId=\"" + task.getStartedEventId() + "\" workflowExecutionRunId=\"" + execution.getRunId() + "\" workflowExecutionId=\"" + execution.getWorkflowId() + "\"", failure);
        return e2;
    }

    @Override
    public void shutdown() {
        this.taskExecutorService.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.taskExecutorService.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.taskExecutorService.awaitTermination(timeout, unit);
    }
}

