/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class History
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<HistoryEvent> events;
    private String nextPageToken;

    public List<HistoryEvent> getEvents() {
        return this.events;
    }

    public void setEvents(Collection<HistoryEvent> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        ListWithAutoConstructFlag eventsCopy = new ListWithAutoConstructFlag(events.size());
        eventsCopy.addAll(events);
        this.events = eventsCopy;
    }

    public History withEvents(HistoryEvent ... events) {
        if (this.getEvents() == null) {
            this.setEvents(new ArrayList<HistoryEvent>(events.length));
        }
        for (HistoryEvent value : events) {
            this.getEvents().add(value);
        }
        return this;
    }

    public History withEvents(Collection<HistoryEvent> events) {
        if (events == null) {
            this.events = null;
        } else {
            ListWithAutoConstructFlag eventsCopy = new ListWithAutoConstructFlag(events.size());
            eventsCopy.addAll(events);
            this.events = eventsCopy;
        }
        return this;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public History withNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvents() != null) {
            sb.append("Events: " + this.getEvents() + ",");
        }
        if (this.getNextPageToken() != null) {
            sb.append("NextPageToken: " + this.getNextPageToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageToken() == null ? 0 : this.getNextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof History)) {
            return false;
        }
        History other = (History)obj;
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        if (other.getEvents() != null && !other.getEvents().equals(this.getEvents())) {
            return false;
        }
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null) {
            return false;
        }
        return other.getNextPageToken() == null || other.getNextPageToken().equals(this.getNextPageToken());
    }

    public History clone() {
        try {
            return (History)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

