/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.CreatePlatformApplicationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class CreatePlatformApplicationRequestMarshaller
implements Marshaller<Request<CreatePlatformApplicationRequest>, CreatePlatformApplicationRequest> {
    @Override
    public Request<CreatePlatformApplicationRequest> marshall(CreatePlatformApplicationRequest createPlatformApplicationRequest) {
        if (createPlatformApplicationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreatePlatformApplicationRequest> request = new DefaultRequest<CreatePlatformApplicationRequest>(createPlatformApplicationRequest, "AmazonSNS");
        request.addParameter("Action", "CreatePlatformApplication");
        request.addParameter("Version", "2010-03-31");
        if (createPlatformApplicationRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString(createPlatformApplicationRequest.getName()));
        }
        if (createPlatformApplicationRequest.getPlatform() != null) {
            request.addParameter("Platform", StringUtils.fromString(createPlatformApplicationRequest.getPlatform()));
        }
        if (createPlatformApplicationRequest != null && createPlatformApplicationRequest.getAttributes() != null) {
            int attributesListIndex = 1;
            for (Map.Entry<String, String> attributesListValue : createPlatformApplicationRequest.getAttributes().entrySet()) {
                if (attributesListValue.getKey() != null) {
                    request.addParameter("Attributes.entry." + attributesListIndex + ".key", StringUtils.fromString(attributesListValue.getKey()));
                }
                if (attributesListValue.getValue() != null) {
                    request.addParameter("Attributes.entry." + attributesListIndex + ".value", StringUtils.fromString(attributesListValue.getValue()));
                }
                ++attributesListIndex;
            }
        }
        return request;
    }
}

