/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MessageAttributeValue
implements Serializable,
Cloneable {
    private String stringValue;
    private ByteBuffer binaryValue;
    private ListWithAutoConstructFlag<String> stringListValues;
    private ListWithAutoConstructFlag<ByteBuffer> binaryListValues;
    private String dataType;

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public MessageAttributeValue withStringValue(String stringValue) {
        this.stringValue = stringValue;
        return this;
    }

    public ByteBuffer getBinaryValue() {
        return this.binaryValue;
    }

    public void setBinaryValue(ByteBuffer binaryValue) {
        this.binaryValue = binaryValue;
    }

    public MessageAttributeValue withBinaryValue(ByteBuffer binaryValue) {
        this.binaryValue = binaryValue;
        return this;
    }

    public List<String> getStringListValues() {
        if (this.stringListValues == null) {
            this.stringListValues = new ListWithAutoConstructFlag();
            this.stringListValues.setAutoConstruct(true);
        }
        return this.stringListValues;
    }

    public void setStringListValues(Collection<String> stringListValues) {
        if (stringListValues == null) {
            this.stringListValues = null;
            return;
        }
        ListWithAutoConstructFlag stringListValuesCopy = new ListWithAutoConstructFlag(stringListValues.size());
        stringListValuesCopy.addAll(stringListValues);
        this.stringListValues = stringListValuesCopy;
    }

    public MessageAttributeValue withStringListValues(String ... stringListValues) {
        if (this.getStringListValues() == null) {
            this.setStringListValues(new ArrayList<String>(stringListValues.length));
        }
        for (String value : stringListValues) {
            this.getStringListValues().add(value);
        }
        return this;
    }

    public MessageAttributeValue withStringListValues(Collection<String> stringListValues) {
        if (stringListValues == null) {
            this.stringListValues = null;
        } else {
            ListWithAutoConstructFlag stringListValuesCopy = new ListWithAutoConstructFlag(stringListValues.size());
            stringListValuesCopy.addAll(stringListValues);
            this.stringListValues = stringListValuesCopy;
        }
        return this;
    }

    public List<ByteBuffer> getBinaryListValues() {
        if (this.binaryListValues == null) {
            this.binaryListValues = new ListWithAutoConstructFlag();
            this.binaryListValues.setAutoConstruct(true);
        }
        return this.binaryListValues;
    }

    public void setBinaryListValues(Collection<ByteBuffer> binaryListValues) {
        if (binaryListValues == null) {
            this.binaryListValues = null;
            return;
        }
        ListWithAutoConstructFlag binaryListValuesCopy = new ListWithAutoConstructFlag(binaryListValues.size());
        binaryListValuesCopy.addAll(binaryListValues);
        this.binaryListValues = binaryListValuesCopy;
    }

    public MessageAttributeValue withBinaryListValues(ByteBuffer ... binaryListValues) {
        if (this.getBinaryListValues() == null) {
            this.setBinaryListValues(new ArrayList<ByteBuffer>(binaryListValues.length));
        }
        for (ByteBuffer value : binaryListValues) {
            this.getBinaryListValues().add(value);
        }
        return this;
    }

    public MessageAttributeValue withBinaryListValues(Collection<ByteBuffer> binaryListValues) {
        if (binaryListValues == null) {
            this.binaryListValues = null;
        } else {
            ListWithAutoConstructFlag binaryListValuesCopy = new ListWithAutoConstructFlag(binaryListValues.size());
            binaryListValuesCopy.addAll(binaryListValues);
            this.binaryListValues = binaryListValuesCopy;
        }
        return this;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public MessageAttributeValue withDataType(String dataType) {
        this.dataType = dataType;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStringValue() != null) {
            sb.append("StringValue: " + this.getStringValue() + ",");
        }
        if (this.getBinaryValue() != null) {
            sb.append("BinaryValue: " + this.getBinaryValue() + ",");
        }
        if (this.getStringListValues() != null) {
            sb.append("StringListValues: " + this.getStringListValues() + ",");
        }
        if (this.getBinaryListValues() != null) {
            sb.append("BinaryListValues: " + this.getBinaryListValues() + ",");
        }
        if (this.getDataType() != null) {
            sb.append("DataType: " + this.getDataType());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStringValue() == null ? 0 : this.getStringValue().hashCode());
        hashCode = 31 * hashCode + (this.getBinaryValue() == null ? 0 : this.getBinaryValue().hashCode());
        hashCode = 31 * hashCode + (this.getStringListValues() == null ? 0 : this.getStringListValues().hashCode());
        hashCode = 31 * hashCode + (this.getBinaryListValues() == null ? 0 : this.getBinaryListValues().hashCode());
        hashCode = 31 * hashCode + (this.getDataType() == null ? 0 : this.getDataType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageAttributeValue)) {
            return false;
        }
        MessageAttributeValue other = (MessageAttributeValue)obj;
        if (other.getStringValue() == null ^ this.getStringValue() == null) {
            return false;
        }
        if (other.getStringValue() != null && !other.getStringValue().equals(this.getStringValue())) {
            return false;
        }
        if (other.getBinaryValue() == null ^ this.getBinaryValue() == null) {
            return false;
        }
        if (other.getBinaryValue() != null && !other.getBinaryValue().equals(this.getBinaryValue())) {
            return false;
        }
        if (other.getStringListValues() == null ^ this.getStringListValues() == null) {
            return false;
        }
        if (other.getStringListValues() != null && !other.getStringListValues().equals(this.getStringListValues())) {
            return false;
        }
        if (other.getBinaryListValues() == null ^ this.getBinaryListValues() == null) {
            return false;
        }
        if (other.getBinaryListValues() != null && !other.getBinaryListValues().equals(this.getBinaryListValues())) {
            return false;
        }
        if (other.getDataType() == null ^ this.getDataType() == null) {
            return false;
        }
        return other.getDataType() == null || other.getDataType().equals(this.getDataType());
    }

    public MessageAttributeValue clone() {
        try {
            return (MessageAttributeValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

