/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.notification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.duracloud.appconfig.domain.NotificationConfig;
import org.duracloud.common.notification.NotificationType;
import org.duracloud.common.notification.Notifier;
import org.duracloud.notification.AmazonNotificationFactory;
import org.duracloud.notification.Emailer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailNotifier
implements Notifier {
    private final Logger log = LoggerFactory.getLogger(EmailNotifier.class);
    private Emailer emailer;
    private List<String> adminEmails;

    @Override
    public void initialize(NotificationConfig notificationConfig) {
        AmazonNotificationFactory factory = new AmazonNotificationFactory();
        factory.initialize(notificationConfig.getUsername(), notificationConfig.getPassword());
        this.emailer = factory.getEmailer(notificationConfig.getOriginator());
        this.adminEmails = notificationConfig.getAdmins();
        if (null == this.adminEmails) {
            this.adminEmails = new ArrayList<String>();
        }
    }

    protected void setEmailer(Emailer emailer) {
        this.emailer = emailer;
    }

    protected void setAdminEmails(List<String> adminEmails) {
        this.adminEmails = adminEmails;
    }

    @Override
    public NotificationType getNotificationType() {
        return NotificationType.EMAIL;
    }

    @Override
    public void notify(String subject, String message, String ... emailAddrs) {
        this.checkInitialized();
        this.log.debug("Sending email to " + Arrays.toString(emailAddrs) + " with subject: [" + subject + "] and message: [" + message + "]");
        this.emailer.send(subject, message, emailAddrs);
    }

    @Override
    public void notifyAdmins(String subject, String message) {
        this.checkInitialized();
        this.log.debug("Sending email to " + this.adminEmails.size() + " administrators with subject: [" + subject + "] and message: [" + message + "]");
        this.emailer.send(subject, message, this.adminEmails.toArray(new String[this.adminEmails.size()]));
    }

    private void checkInitialized() {
        if (null == this.emailer) {
            throw new RuntimeException("The Email Notifier must be initialized prior to use!");
        }
    }
}

