/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.retrieval.mgmt;

import org.apache.commons.lang3.StringUtils;
import org.duracloud.common.model.ContentItem;
import org.duracloud.retrieval.mgmt.OutputWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingOutputWriter
implements OutputWriter {
    private Logger log = LoggerFactory.getLogger("retrieval-log");
    protected static final String SUCCESS = "RETRIEVED";
    protected static final String FAILURE = "FAILED";

    @Override
    public void writeSuccess(ContentItem contentItem, String localFilePath, int attempts) {
        this.log.info(this.format(new Object[]{SUCCESS, contentItem.getSpaceId(), contentItem.getContentId(), localFilePath}));
    }

    private String format(Object[] objects) {
        return StringUtils.join(objects, "\t");
    }

    @Override
    public void writeFailure(ContentItem contentItem, String error, int attempts) {
        this.log.info(this.format(new Object[]{FAILURE, contentItem.getSpaceId(), contentItem.getContentId(), "attempts:" + attempts, "error:" + error}));
    }

    @Override
    public void close() {
    }
}

