/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.security.vote;

import java.util.Collection;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.vote.AbstractAccessDecisionManager;
import org.springframework.security.core.Authentication;

public class AccessDecisionManagerImpl
extends AbstractAccessDecisionManager {
    @Override
    public void decide(Authentication authentication, Object resource, Collection<ConfigAttribute> config) throws AccessDeniedException {
        int grant = 0;
        for (AccessDecisionVoter<? extends Object> voter : this.getDecisionVoters()) {
            int decision = voter.vote(authentication, resource, config);
            switch (decision) {
                case 1: {
                    ++grant;
                    break;
                }
                case -1: {
                    throw new AccessDeniedException(this.messages.getMessage("AbstractAccessDecisionManager.accessDenied", "Access is denied"));
                }
            }
        }
        if (grant > 0) {
            return;
        }
        this.checkAllowIfAllAbstainDecisions();
    }
}

