/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.io.File;
import org.duracloud.client.ContentStore;
import org.duracloud.manifeststitch.StitchedManifestGenerator;
import org.duracloud.retrieval.util.StoreClientUtil;
import org.duracloud.snapshot.SnapshotException;
import org.duracloud.snapshot.db.ContentDirUtils;
import org.duracloud.snapshot.db.model.DuracloudEndPointConfig;
import org.duracloud.snapshot.db.model.Restoration;
import org.duracloud.snapshot.db.model.SnapshotContentItem;
import org.duracloud.snapshot.db.repo.SnapshotContentItemRepo;
import org.duracloud.snapshot.service.RestoreManager;
import org.duracloud.snapshot.service.SnapshotJobManagerConfig;
import org.duracloud.snapshot.service.impl.BatchJobBuilder;
import org.duracloud.snapshot.service.impl.ContentProperties;
import org.duracloud.snapshot.service.impl.ContentPropertiesFileReader;
import org.duracloud.snapshot.service.impl.ContentPropertiesWriter;
import org.duracloud.snapshot.service.impl.DpnManifestReader;
import org.duracloud.snapshot.service.impl.FileSystemReader;
import org.duracloud.snapshot.service.impl.ManifestEntry;
import org.duracloud.snapshot.service.impl.ManifestVerifier;
import org.duracloud.snapshot.service.impl.RestoreJobExecutionListener;
import org.duracloud.snapshot.service.impl.RestoreJobParameterMarshaller;
import org.duracloud.snapshot.service.impl.SnapshotContentItemVerifier;
import org.duracloud.snapshot.service.impl.SnapshotRepoManifestReader;
import org.duracloud.snapshot.service.impl.SpaceManifestDpnManifestVerifier;
import org.duracloud.snapshot.service.impl.SpaceVerifier;
import org.duracloud.snapshot.service.impl.SyncWriter;
import org.duracloud.sync.endpoint.DuraStoreChunkSyncEndpoint;
import org.duracloud.sync.endpoint.EndPointLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.factory.SimpleStepFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;

@Component
public class RestoreJobBuilder
implements BatchJobBuilder<Restoration> {
    private static Logger log = LoggerFactory.getLogger(RestoreJobBuilder.class);
    private RestoreJobExecutionListener jobListener;
    private JobRepository jobRepository;
    private PlatformTransactionManager transactionManager;
    private TaskExecutor taskExecutor;
    private RestoreManager restoreManager;
    private SnapshotContentItemRepo snapshotContentItemRepo;

    @Autowired
    public RestoreJobBuilder(RestoreJobExecutionListener jobListener, JobRepository jobRepository, PlatformTransactionManager transactionManager, @Qualifier(value="itemTaskExecutor") TaskExecutor taskExecutor, RestoreManager restoreManager, SnapshotContentItemRepo snapshotContentItemRepo) {
        this.jobListener = jobListener;
        this.jobRepository = jobRepository;
        this.transactionManager = transactionManager;
        this.taskExecutor = taskExecutor;
        this.restoreManager = restoreManager;
        this.snapshotContentItemRepo = snapshotContentItemRepo;
    }

    @Override
    public Job buildJob(Restoration restoration, SnapshotJobManagerConfig jobManagerConfig) throws SnapshotException {
        Job job;
        try {
            DuracloudEndPointConfig destination = restoration.getDestination();
            String destinationSpaceId = destination.getSpaceId();
            String restoreId = restoration.getRestorationId();
            StoreClientUtil clientUtil = new StoreClientUtil();
            ContentStore contentStore = clientUtil.createContentStore(destination.getHost(), destination.getPort(), "durastore", jobManagerConfig.getDuracloudUsername(), jobManagerConfig.getDuracloudPassword(), destination.getStoreId());
            JobBuilderFactory jobBuilderFactory = new JobBuilderFactory(this.jobRepository);
            JobBuilder jobBuilder = jobBuilderFactory.get(this.getJobName());
            SimpleJobBuilder simpleJobBuilder = jobBuilder.start(this.buildVerifyDpnTransferUsingDpnManifestStep(restoreId, jobManagerConfig)).next(this.buildVerifyDpnTransferUsingSnapshotRepoStep(restoreId, jobManagerConfig)).next(this.buildRestoreContentStep(restoreId, destinationSpaceId, contentStore, jobManagerConfig)).next(this.buildRestoreContentPropertiesStep(restoreId, destinationSpaceId, contentStore, jobManagerConfig)).next(this.buildVerifyDuraCloudTransferStep(restoreId, destinationSpaceId, contentStore, jobManagerConfig));
            simpleJobBuilder.listener(this.jobListener);
            job = simpleJobBuilder.build();
            log.debug("build job {}", (Object)job);
        }
        catch (Exception e) {
            log.error("Error creating job: {}", (Object)e.getMessage(), (Object)e);
            throw new SnapshotException(e.getMessage(), e);
        }
        return job;
    }

    private Step buildVerifyDpnTransferUsingSnapshotRepoStep(String restoreId, SnapshotJobManagerConfig jobManagerConfig) throws Exception {
        File restoreDir = new File(ContentDirUtils.getSourcePath(restoreId, jobManagerConfig.getContentRootDir()));
        Restoration restore = this.restoreManager.get(restoreId);
        SnapshotRepoManifestReader reader = new SnapshotRepoManifestReader(this.snapshotContentItemRepo, restore.getSnapshot().getName());
        SnapshotContentItemVerifier writer = new SnapshotContentItemVerifier(restoreId, this.getRestoreMd5Manifest(restoreDir), restore.getSnapshot().getName(), this.restoreManager);
        SimpleStepFactoryBean<SnapshotContentItem, SnapshotContentItem> stepFactory = new SimpleStepFactoryBean<SnapshotContentItem, SnapshotContentItem>();
        stepFactory.setJobRepository(this.jobRepository);
        stepFactory.setTransactionManager(this.transactionManager);
        stepFactory.setBeanName("verifyDpnTransferUsingSnapshotRepo");
        stepFactory.setItemReader(reader);
        stepFactory.setItemWriter(writer);
        stepFactory.setCommitInterval(50);
        stepFactory.setThrottleLimit(20);
        stepFactory.setTaskExecutor(this.taskExecutor);
        stepFactory.setListeners(new StepListener[]{writer});
        return stepFactory.getObject();
    }

    private Step buildVerifyDuraCloudTransferStep(String restoreId, String destinationSpaceId, ContentStore contentStore, SnapshotJobManagerConfig jobManagerConfig) throws Exception {
        File restoreDir = this.getRestoreDir(restoreId, jobManagerConfig);
        File md5Manifest = this.getRestoreMd5Manifest(restoreDir);
        DpnManifestReader reader = new DpnManifestReader(md5Manifest);
        SpaceManifestDpnManifestVerifier spaceManifestVerifier = new SpaceManifestDpnManifestVerifier(md5Manifest, new StitchedManifestGenerator(contentStore), destinationSpaceId);
        SpaceVerifier writer = new SpaceVerifier(restoreId, spaceManifestVerifier, destinationSpaceId, this.restoreManager);
        SimpleStepFactoryBean<ManifestEntry, ManifestEntry> stepFactory = new SimpleStepFactoryBean<ManifestEntry, ManifestEntry>();
        stepFactory.setJobRepository(this.jobRepository);
        stepFactory.setTransactionManager(this.transactionManager);
        stepFactory.setBeanName("verifyDuraCloudTransfer");
        stepFactory.setItemReader(reader);
        stepFactory.setItemWriter(writer);
        stepFactory.setCommitInterval(1);
        stepFactory.setThrottleLimit(20);
        stepFactory.setTaskExecutor(this.taskExecutor);
        stepFactory.setListeners(new StepListener[]{writer});
        stepFactory.setAllowStartIfComplete(false);
        return stepFactory.getObject();
    }

    private Step buildVerifyDpnTransferUsingDpnManifestStep(String restoreId, SnapshotJobManagerConfig jobManagerConfig) throws Exception {
        File restoreDir = this.getRestoreDir(restoreId, jobManagerConfig);
        File md5Manifest = this.getRestoreMd5Manifest(restoreDir);
        DpnManifestReader reader = new DpnManifestReader(md5Manifest);
        File contentDir = this.getRestoreContentDir(restoreDir);
        ManifestVerifier writer = new ManifestVerifier(restoreId, contentDir, this.restoreManager);
        SimpleStepFactoryBean<ManifestEntry, ManifestEntry> stepFactory = new SimpleStepFactoryBean<ManifestEntry, ManifestEntry>();
        stepFactory.setJobRepository(this.jobRepository);
        stepFactory.setTransactionManager(this.transactionManager);
        stepFactory.setBeanName("verifyDpnTransferUsingDpnManifest");
        stepFactory.setItemReader(reader);
        stepFactory.setItemWriter(writer);
        stepFactory.setCommitInterval(50);
        stepFactory.setThrottleLimit(20);
        stepFactory.setTaskExecutor(this.taskExecutor);
        stepFactory.setListeners(new StepListener[]{writer, reader});
        return stepFactory.getObject();
    }

    private File getRestoreMd5Manifest(File restoreDir) {
        File md5Manifest = new File(restoreDir, "manifest-md5.txt");
        if (!md5Manifest.exists()) {
            throw new RuntimeException("The md5 manifest file is missing: " + md5Manifest.getAbsolutePath());
        }
        return md5Manifest;
    }

    private File getRestoreContentDir(File restoreDir) {
        File contentDir = new File(restoreDir, "data");
        if (!contentDir.exists()) {
            throw new RuntimeException("The content direcotry is missing for restoration:  " + contentDir.getAbsolutePath());
        }
        return contentDir;
    }

    private File getRestoreDir(String restorationId, SnapshotJobManagerConfig jobManagerConfig) {
        File restoreDir = new File(ContentDirUtils.getSourcePath(restorationId, jobManagerConfig.getContentRootDir()));
        if (!restoreDir.exists()) {
            throw new RuntimeException("The directory for the restored snapshot does not exist in bridge storage: missing: " + restoreDir.getAbsolutePath());
        }
        return restoreDir;
    }

    private Step buildRestoreContentPropertiesStep(String restorationId, String destinationSpaceId, ContentStore contentStore, SnapshotJobManagerConfig jobManagerConfig) throws Exception {
        File contentPropertiesJsonFile = new File(ContentDirUtils.getSourcePath(restorationId, jobManagerConfig.getContentRootDir()), "content-properties.json");
        if (!contentPropertiesJsonFile.exists()) {
            throw new RuntimeException("The restored content properties file is missing : " + contentPropertiesJsonFile.getAbsolutePath());
        }
        ContentPropertiesFileReader reader = new ContentPropertiesFileReader(contentPropertiesJsonFile);
        ContentPropertiesWriter writer = new ContentPropertiesWriter(contentStore, destinationSpaceId);
        SimpleStepFactoryBean<ContentProperties, ContentProperties> stepFactory = new SimpleStepFactoryBean<ContentProperties, ContentProperties>();
        stepFactory.setJobRepository(this.jobRepository);
        stepFactory.setTransactionManager(this.transactionManager);
        stepFactory.setBeanName("restoreContentProperties");
        stepFactory.setItemReader(reader);
        stepFactory.setItemWriter(writer);
        stepFactory.setCommitInterval(1);
        stepFactory.setThrottleLimit(20);
        stepFactory.setTaskExecutor(this.taskExecutor);
        stepFactory.setListeners(new StepListener[]{writer});
        return stepFactory.getObject();
    }

    private Step buildRestoreContentStep(String restorationId, String destinationSpaceId, ContentStore contentStore, SnapshotJobManagerConfig jobManagerConfig) throws Exception {
        DuraStoreChunkSyncEndpoint endpoint = new DuraStoreChunkSyncEndpoint(contentStore, jobManagerConfig.getDuracloudUsername(), destinationSpaceId, false, true, 0x40000000L);
        endpoint.addEndPointListener(new EndPointLogger());
        File watchDir = new File(ContentDirUtils.getSourcePath(restorationId, jobManagerConfig.getContentRootDir()) + File.separator + "data");
        if (!watchDir.exists()) {
            throw new RuntimeException("The content directory for the restored snapshot does not exist in bridge storage: missing watchDir: " + watchDir.getAbsolutePath());
        }
        FileSystemReader reader = new FileSystemReader(watchDir);
        SyncWriter writer = new SyncWriter(restorationId, watchDir, endpoint, contentStore, destinationSpaceId, this.restoreManager);
        SimpleStepFactoryBean<File, File> stepFactory = new SimpleStepFactoryBean<File, File>();
        stepFactory.setJobRepository(this.jobRepository);
        stepFactory.setTransactionManager(this.transactionManager);
        stepFactory.setBeanName("restoreContent");
        stepFactory.setItemReader(reader);
        stepFactory.setItemWriter(writer);
        stepFactory.setCommitInterval(20);
        stepFactory.setThrottleLimit(20);
        stepFactory.setTaskExecutor(this.taskExecutor);
        stepFactory.setListeners(new StepListener[]{writer});
        return stepFactory.getObject();
    }

    @Override
    public JobParameters buildIdentifyingJobParameters(Restoration restoration) {
        return new JobParameters(RestoreJobParameterMarshaller.marshal(restoration));
    }

    @Override
    public JobParameters buildJobParameters(Restoration entity) {
        return this.buildIdentifyingJobParameters(entity);
    }

    @Override
    public String getJobName() {
        return "restore";
    }
}

