/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.util.List;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.snapshot.dto.RestoreStatus;
import org.duracloud.snapshot.service.RestoreManager;
import org.duracloud.snapshot.service.impl.ManifestEntry;
import org.duracloud.snapshot.service.impl.SpaceManifestDpnManifestVerifier;
import org.duracloud.snapshot.service.impl.StepExecutionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.item.ItemWriter;

public class SpaceVerifier
extends StepExecutionSupport
implements ItemWriter<ManifestEntry>,
ItemWriteListener<ManifestEntry> {
    private Logger log = LoggerFactory.getLogger(SpaceVerifier.class);
    private String spaceId;
    private RestoreManager restoreManager;
    private String restoreId;
    private SpaceManifestDpnManifestVerifier verifier;

    public SpaceVerifier(String restoreId, SpaceManifestDpnManifestVerifier verifier, String spaceId, RestoreManager restoreManager) {
        this.restoreId = restoreId;
        this.verifier = verifier;
        this.spaceId = spaceId;
        this.restoreManager = restoreManager;
    }

    @Override
    public void beforeWrite(List<? extends ManifestEntry> items) {
    }

    @Override
    public void afterWrite(List<? extends ManifestEntry> items) {
    }

    @Override
    public void onWriteError(Exception ex, List<? extends ManifestEntry> items) {
    }

    @Override
    public void write(List<? extends ManifestEntry> items) throws Exception {
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
        super.beforeStep(stepExecution);
        try {
            new Retrier().execute(new Retriable(){

                @Override
                public Object retry() throws Exception {
                    RestoreStatus newStatus = RestoreStatus.VERIFYING_TRANSFERRED_CONTENT;
                    SpaceVerifier.this.restoreManager.transitionRestoreStatus(SpaceVerifier.this.restoreId, newStatus, "");
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.addError("failed to transition status to " + (Object)((Object)RestoreStatus.VERIFYING_TRANSFERRED_CONTENT) + ": " + ex.getMessage());
            stepExecution.addFailureException(ex);
        }
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        if (this.getErrors().size() == 0) {
            List<String> verifyErrors = this.verifySpace(this.verifier);
            for (String error : verifyErrors) {
                this.addError(error);
            }
        }
        ExitStatus status = stepExecution.getExitStatus();
        List<String> errors = this.getErrors();
        if (errors.size() > 0) {
            status = status.and(ExitStatus.FAILED);
            for (String error : errors) {
                status = status.addExitDescription(error);
            }
            this.failExecution();
            this.log.error("space verification step finished: step_execution_id={} job_execution_id={}  spaceId={} status=\"{}\"", stepExecution.getId(), stepExecution.getJobExecutionId(), this.spaceId, status);
        } else {
            status = status.and(ExitStatus.COMPLETED);
            this.log.info("space verification step finished: step_execution_id={} job_execution_id={}  spaceId={} exit_status={} ", stepExecution.getId(), stepExecution.getJobExecutionId(), this.spaceId, status);
        }
        return status;
    }
}

