/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.boot.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jpa.boot.archive.internal.ArchiveHelper;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.internal.EntityManagerMessageLogger;
import org.hibernate.jpa.internal.util.ConfigurationHelper;
import org.hibernate.metamodel.source.XsdException;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PersistenceXmlParser {
    private static final EntityManagerMessageLogger LOG = Logger.getMessageLogger(EntityManagerMessageLogger.class, PersistenceXmlParser.class.getName());
    private final ClassLoaderService classLoaderService;
    private final PersistenceUnitTransactionType defaultTransactionType;
    private DocumentBuilderFactory documentBuilderFactory;
    private Schema v21Schema;
    private Schema v2Schema;
    private Schema v1Schema;

    public static List<ParsedPersistenceXmlDescriptor> locatePersistenceUnits(Map integration) {
        PersistenceXmlParser parser = new PersistenceXmlParser(ClassLoaderServiceImpl.fromConfigSettings(integration), PersistenceUnitTransactionType.RESOURCE_LOCAL);
        return parser.doResolve(integration);
    }

    public PersistenceXmlParser(ClassLoaderService classLoaderService, PersistenceUnitTransactionType defaultTransactionType) {
        this.classLoaderService = classLoaderService;
        this.defaultTransactionType = defaultTransactionType;
    }

    public List<ParsedPersistenceXmlDescriptor> doResolve(Map integration) {
        ArrayList<ParsedPersistenceXmlDescriptor> persistenceUnits = new ArrayList<ParsedPersistenceXmlDescriptor>();
        List<URL> xmlUrls = this.classLoaderService.locateResources("META-INF/persistence.xml");
        if (xmlUrls.isEmpty()) {
            LOG.unableToFindPersistenceXmlInClasspath();
        } else {
            for (URL xmlUrl : xmlUrls) {
                persistenceUnits.addAll(this.parsePersistenceXml(xmlUrl, integration));
            }
        }
        return persistenceUnits;
    }

    private List<ParsedPersistenceXmlDescriptor> parsePersistenceXml(URL xmlUrl, Map integration) {
        LOG.tracef("Attempting to parse persistence.xml file : %s", (Object)xmlUrl.toExternalForm());
        Document doc = this.loadUrl(xmlUrl);
        Element top = doc.getDocumentElement();
        ArrayList<ParsedPersistenceXmlDescriptor> persistenceUnits = new ArrayList<ParsedPersistenceXmlDescriptor>();
        NodeList children = top.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element element;
            String tag;
            if (children.item(i).getNodeType() != 1 || !(tag = (element = (Element)children.item(i)).getTagName()).equals("persistence-unit")) continue;
            URL puRootUrl = ArchiveHelper.getJarURLFromURLEntry(xmlUrl, "/META-INF/persistence.xml");
            ParsedPersistenceXmlDescriptor persistenceUnit = new ParsedPersistenceXmlDescriptor(puRootUrl);
            this.bindPersistenceUnit(persistenceUnit, element);
            if (integration.containsKey("javax.persistence.provider")) {
                persistenceUnit.setProviderClassName((String)integration.get("javax.persistence.provider"));
            }
            if (integration.containsKey("javax.persistence.transactionType")) {
                String transactionType = (String)integration.get("javax.persistence.transactionType");
                persistenceUnit.setTransactionType(PersistenceXmlParser.parseTransactionType(transactionType));
            }
            if (integration.containsKey("javax.persistence.jtaDataSource")) {
                persistenceUnit.setJtaDataSource(integration.get("javax.persistence.jtaDataSource"));
            }
            if (integration.containsKey("javax.persistence.nonJtaDataSource")) {
                persistenceUnit.setNonJtaDataSource(integration.get("javax.persistence.nonJtaDataSource"));
            }
            this.decodeTransactionType(persistenceUnit);
            Properties properties = persistenceUnit.getProperties();
            ConfigurationHelper.overrideProperties(properties, integration);
            persistenceUnits.add(persistenceUnit);
        }
        return persistenceUnits;
    }

    private void decodeTransactionType(ParsedPersistenceXmlDescriptor persistenceUnit) {
        if (persistenceUnit.getTransactionType() != null) {
            return;
        }
        if (persistenceUnit.getJtaDataSource() != null) {
            persistenceUnit.setTransactionType(PersistenceUnitTransactionType.JTA);
        } else if (persistenceUnit.getNonJtaDataSource() != null) {
            persistenceUnit.setTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL);
        } else {
            persistenceUnit.setTransactionType(this.defaultTransactionType);
        }
    }

    private void bindPersistenceUnit(ParsedPersistenceXmlDescriptor persistenceUnit, Element persistenceUnitElement) {
        PersistenceUnitTransactionType transactionType;
        String name = persistenceUnitElement.getAttribute("name");
        if (StringHelper.isNotEmpty(name)) {
            LOG.tracef("Persistence unit name from persistence.xml : %s", (Object)name);
            persistenceUnit.setName(name);
        }
        if ((transactionType = PersistenceXmlParser.parseTransactionType(persistenceUnitElement.getAttribute("transaction-type"))) != null) {
            persistenceUnit.setTransactionType(transactionType);
        }
        NodeList children = persistenceUnitElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            Element element = (Element)children.item(i);
            String tag = element.getTagName();
            if (tag.equals("non-jta-data-source")) {
                persistenceUnit.setNonJtaDataSource(PersistenceXmlParser.extractContent(element));
                continue;
            }
            if (tag.equals("jta-data-source")) {
                persistenceUnit.setJtaDataSource(PersistenceXmlParser.extractContent(element));
                continue;
            }
            if (tag.equals("provider")) {
                persistenceUnit.setProviderClassName(PersistenceXmlParser.extractContent(element));
                continue;
            }
            if (tag.equals("class")) {
                persistenceUnit.addClasses(PersistenceXmlParser.extractContent(element));
                continue;
            }
            if (tag.equals("mapping-file")) {
                persistenceUnit.addMappingFiles(PersistenceXmlParser.extractContent(element));
                continue;
            }
            if (tag.equals("jar-file")) {
                persistenceUnit.addJarFileUrl(ArchiveHelper.getURLFromPath(PersistenceXmlParser.extractContent(element)));
                continue;
            }
            if (tag.equals("exclude-unlisted-classes")) {
                persistenceUnit.setExcludeUnlistedClasses(PersistenceXmlParser.extractBooleanContent(element, true));
                continue;
            }
            if (tag.equals("delimited-identifiers")) {
                persistenceUnit.setUseQuotedIdentifiers(true);
                continue;
            }
            if (tag.equals("validation-mode")) {
                persistenceUnit.setValidationMode(PersistenceXmlParser.extractContent(element));
                continue;
            }
            if (tag.equals("shared-cache-mode")) {
                persistenceUnit.setSharedCacheMode(PersistenceXmlParser.extractContent(element));
                continue;
            }
            if (!tag.equals("properties")) continue;
            NodeList props = element.getChildNodes();
            for (int j = 0; j < props.getLength(); ++j) {
                Element propElement;
                if (props.item(j).getNodeType() != 1 || !"property".equals((propElement = (Element)props.item(j)).getTagName())) continue;
                String propName = propElement.getAttribute("name").trim();
                String propValue = propElement.getAttribute("value").trim();
                if (StringHelper.isEmpty(propValue)) {
                    propValue = PersistenceXmlParser.extractContent(propElement, "");
                }
                persistenceUnit.getProperties().put(propName, propValue);
            }
        }
    }

    private static String extractContent(Element element) {
        return PersistenceXmlParser.extractContent(element, null);
    }

    private static String extractContent(Element element, String defaultStr) {
        if (element == null) {
            return defaultStr;
        }
        NodeList children = element.getChildNodes();
        StringBuilder result = new StringBuilder("");
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 3 && children.item(i).getNodeType() != 4) continue;
            result.append(children.item(i).getNodeValue());
        }
        return result.toString().trim();
    }

    private static boolean extractBooleanContent(Element element, boolean defaultBool) {
        String content = PersistenceXmlParser.extractContent(element);
        if (content != null && content.length() > 0) {
            return Boolean.valueOf(content);
        }
        return defaultBool;
    }

    private static PersistenceUnitTransactionType parseTransactionType(String value) {
        if (StringHelper.isEmpty(value)) {
            return null;
        }
        if (value.equalsIgnoreCase("JTA")) {
            return PersistenceUnitTransactionType.JTA;
        }
        if (value.equalsIgnoreCase("RESOURCE_LOCAL")) {
            return PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        throw new PersistenceException("Unknown persistence unit transaction type : " + value);
    }

    /*
     * Exception decompiling
     */
    private Document loadUrl(URL xmlUrl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK]], but top level block is 9[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void validate(Document document) {
        Validator validator;
        String version = document.getDocumentElement().getAttribute("version");
        if ("2.1".equals(version)) {
            validator = this.v21Schema().newValidator();
        } else if ("2.0".equals(version)) {
            validator = this.v2Schema().newValidator();
        } else if ("1.0".equals(version)) {
            validator = this.v1Schema().newValidator();
        } else {
            throw new PersistenceException("Unrecognized persistence.xml version [" + version + "]");
        }
        ArrayList<SAXException> errors = new ArrayList<SAXException>();
        validator.setErrorHandler(new ErrorHandlerImpl(errors));
        try {
            validator.validate(new DOMSource(document));
        }
        catch (SAXException e) {
            errors.add(e);
        }
        catch (IOException e) {
            throw new PersistenceException("Unable to validate persistence.xml", e);
        }
        if (errors.size() != 0) {
            StringBuilder errorMessage = new StringBuilder();
            for (SAXException error : errors) {
                errorMessage.append(PersistenceXmlParser.extractInfo(error)).append('\n');
            }
            throw new PersistenceException("Invalid persistence.xml.\n" + errorMessage.toString());
        }
    }

    private DocumentBuilderFactory documentBuilderFactory() {
        if (this.documentBuilderFactory == null) {
            this.documentBuilderFactory = this.buildDocumentBuilderFactory();
        }
        return this.documentBuilderFactory;
    }

    private DocumentBuilderFactory buildDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        return documentBuilderFactory;
    }

    private Schema v21Schema() {
        if (this.v21Schema == null) {
            this.v21Schema = this.resolveLocalSchema("org/hibernate/jpa/persistence_2_1.xsd");
        }
        return this.v21Schema;
    }

    private Schema v2Schema() {
        if (this.v2Schema == null) {
            this.v2Schema = this.resolveLocalSchema("org/hibernate/jpa/persistence_2_0.xsd");
        }
        return this.v2Schema;
    }

    private Schema v1Schema() {
        if (this.v1Schema == null) {
            this.v1Schema = this.resolveLocalSchema("org/hibernate/jpa/persistence_1_0.xsd");
        }
        return this.v1Schema;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Schema resolveLocalSchema(String schemaName) {
        URL url = this.classLoaderService.locateResource(schemaName);
        if (url == null) {
            throw new XsdException("Unable to locate schema [" + schemaName + "] via classpath", schemaName);
        }
        try {
            InputStream schemaStream = url.openStream();
            try {
                StreamSource source = new StreamSource(url.openStream());
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(source);
                return schema;
            }
            catch (SAXException e) {
                throw new XsdException("Unable to load schema [" + schemaName + "]", e, schemaName);
            }
            catch (IOException e) {
                throw new XsdException("Unable to load schema [" + schemaName + "]", e, schemaName);
            }
            finally {
                try {
                    schemaStream.close();
                }
                catch (IOException e) {
                    LOG.debugf("Problem closing schema stream [%s]", (Object)e.toString());
                }
            }
        }
        catch (IOException e) {
            throw new XsdException("Stream error handling schema url [" + url.toExternalForm() + "]", schemaName);
        }
    }

    private static String extractInfo(SAXException error) {
        if (error instanceof SAXParseException) {
            return "Error parsing XML [line : " + ((SAXParseException)error).getLineNumber() + ", column : " + ((SAXParseException)error).getColumnNumber() + "] : " + error.getMessage();
        }
        return "Error parsing XML : " + error.getMessage();
    }

    public static class ErrorHandlerImpl
    implements ErrorHandler {
        private List<SAXException> errors;

        ErrorHandlerImpl(List<SAXException> errors) {
            this.errors = errors;
        }

        @Override
        public void error(SAXParseException error) {
            this.errors.add(error);
        }

        @Override
        public void fatalError(SAXParseException error) {
            this.errors.add(error);
        }

        @Override
        public void warning(SAXParseException warn) {
            LOG.trace(PersistenceXmlParser.extractInfo(warn));
        }
    }
}

