/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal.jpa;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.hibernate.MappingException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.jpa.event.internal.jpa.CallbackProcessor;
import org.hibernate.jpa.event.internal.jpa.CallbackRegistryImpl;
import org.hibernate.jpa.event.internal.jpa.EntityCallback;
import org.hibernate.jpa.event.internal.jpa.ListenerCallback;
import org.hibernate.jpa.event.spi.jpa.Callback;
import org.hibernate.jpa.event.spi.jpa.ListenerFactory;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.metamodel.source.binder.JpaCallbackClass;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.jboss.logging.Logger;

public class CallbackProcessorImpl
implements CallbackProcessor {
    private static final Logger log = Logger.getLogger(CallbackProcessorImpl.class);
    private final ListenerFactory jpaListenerFactory;
    private final MetadataImplementor metadata;
    private final ClassLoaderService classLoaderService;

    public CallbackProcessorImpl(ListenerFactory jpaListenerFactory, MetadataImplementor metadata, SessionFactoryServiceRegistry serviceRegistry) {
        this.jpaListenerFactory = jpaListenerFactory;
        this.metadata = metadata;
        this.classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
    }

    @Override
    public void processCallbacksForEntity(Object entityObject, CallbackRegistryImpl callbackRegistry) {
        EntityBinding entityBinding = (EntityBinding)entityObject;
        String entityClassName = entityBinding.getEntity().getClassName();
        if (entityClassName == null) {
            return;
        }
        try {
            Class entityClass = this.classLoaderService.classForName(entityClassName);
            for (Class annotationClass : CALLBACK_ANNOTATION_CLASSES) {
                callbackRegistry.addEntityCallbacks(entityClass, annotationClass, this.collectCallbacks(entityBinding, entityClass, annotationClass));
            }
        }
        catch (ClassLoadingException e) {
            throw new MappingException("entity class not found: " + entityClassName, e);
        }
    }

    private Callback[] collectCallbacks(EntityBinding entityBinding, Class entityClass, Class annotationClass) {
        ArrayList<Callback> callbacks = new ArrayList<Callback>();
        for (JpaCallbackClass jpaCallbackClass : entityBinding.getJpaCallbackClasses()) {
            Callback callback;
            Class listenerClass = this.classLoaderService.classForName(jpaCallbackClass.getName());
            String methodName = jpaCallbackClass.getCallbackMethod(annotationClass);
            log.debugf("Adding $s.%s as %s callback for entity %s", listenerClass.getName(), methodName, annotationClass.getName(), entityClass.getName());
            Callback callback2 = callback = jpaCallbackClass.isListener() ? this.createListenerCallback(listenerClass, entityClass, methodName) : this.createBeanCallback(listenerClass, methodName);
            assert (callback != null);
            callbacks.add(callback);
        }
        return callbacks.toArray(new Callback[callbacks.size()]);
    }

    private Callback createListenerCallback(Class listenerClass, Class entityClass, String methodName) {
        Callback callback;
        Class callbackSuperclass = listenerClass.getSuperclass();
        if (callbackSuperclass != null && (callback = this.createListenerCallback(entityClass, callbackSuperclass, methodName)) != null) {
            return callback;
        }
        Object listenerInstance = this.jpaListenerFactory.buildListener(listenerClass);
        for (Method method : listenerClass.getDeclaredMethods()) {
            Class<?> argType;
            Class<?>[] argTypes;
            if (!method.getName().equals(methodName) || (argTypes = method.getParameterTypes()).length != 1 || (argType = argTypes[0]) != Object.class && argType != entityClass) continue;
            method.setAccessible(true);
            return new ListenerCallback(listenerInstance, method);
        }
        return null;
    }

    private Callback createBeanCallback(Class<?> callbackClass, String methodName) {
        Callback callback;
        Class<?> callbackSuperclass = callbackClass.getSuperclass();
        if (callbackSuperclass != null && (callback = this.createBeanCallback(callbackSuperclass, methodName)) != null) {
            return callback;
        }
        for (Method method : callbackClass.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != 0) continue;
            method.setAccessible(true);
            return new EntityCallback(method);
        }
        return null;
    }

    @Override
    public void release() {
    }
}

