/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.graph.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.AttributeNode;
import javax.persistence.Subgraph;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.PluralAttribute;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.spi.AttributeNodeImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jpa.HibernateEntityManagerFactory;
import org.hibernate.jpa.graph.internal.SubgraphImpl;
import org.hibernate.jpa.internal.metamodel.Helper;
import org.hibernate.jpa.internal.metamodel.PluralAttributeImpl;
import org.hibernate.jpa.spi.HibernateEntityManagerFactoryAware;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;

public class AttributeNodeImpl<T>
implements AttributeNode<T>,
AttributeNodeImplementor<T>,
HibernateEntityManagerFactoryAware {
    private final HibernateEntityManagerFactory entityManagerFactory;
    private final Attribute<?, T> attribute;
    private Map<Class, Subgraph> subgraphMap;
    private Map<Class, Subgraph> keySubgraphMap;

    public <X> AttributeNodeImpl(HibernateEntityManagerFactory entityManagerFactory, Attribute<X, T> attribute) {
        this.entityManagerFactory = entityManagerFactory;
        this.attribute = attribute;
    }

    private AttributeNodeImpl(HibernateEntityManagerFactory entityManagerFactory, Attribute<?, T> attribute, Map<Class, Subgraph> subgraphMap, Map<Class, Subgraph> keySubgraphMap) {
        this.entityManagerFactory = entityManagerFactory;
        this.attribute = attribute;
        this.subgraphMap = subgraphMap;
        this.keySubgraphMap = keySubgraphMap;
    }

    @Override
    public HibernateEntityManagerFactory getFactory() {
        return this.entityManagerFactory;
    }

    private SessionFactoryImplementor sessionFactory() {
        return (SessionFactoryImplementor)this.getFactory().getSessionFactory();
    }

    @Override
    public Attribute<?, T> getAttribute() {
        return this.attribute;
    }

    public String getRegistrationName() {
        return this.getAttributeName();
    }

    @Override
    public String getAttributeName() {
        return this.attribute.getName();
    }

    @Override
    public Map<Class, Subgraph> getSubgraphs() {
        return this.subgraphMap == null ? Collections.emptyMap() : this.subgraphMap;
    }

    @Override
    public Map<Class, Subgraph> getKeySubgraphs() {
        return this.keySubgraphMap == null ? Collections.emptyMap() : this.keySubgraphMap;
    }

    public <T> SubgraphImpl<T> makeSubgraph() {
        return this.internalMakeSubgraph(null);
    }

    public <X extends T> SubgraphImpl<X> makeSubgraph(Class<X> type) {
        return this.internalMakeSubgraph(type);
    }

    private SubgraphImpl internalMakeSubgraph(Class type) {
        AssociationType attributeType;
        Joinable joinable;
        if (this.attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.BASIC || this.attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED) {
            throw new IllegalArgumentException(String.format("Attribute [%s] is not of managed type", this.getAttributeName()));
        }
        if (this.attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION) {
            throw new IllegalArgumentException(String.format("Collection elements [%s] is not of managed type", this.getAttributeName()));
        }
        if (this.subgraphMap == null) {
            this.subgraphMap = new HashMap<Class, Subgraph>();
        }
        if ((joinable = (attributeType = (AssociationType)Helper.resolveType(this.sessionFactory(), this.attribute)).getAssociatedJoinable(this.sessionFactory())).isCollection()) {
            EntityPersister elementEntityPersister = ((QueryableCollection)joinable).getElementPersister();
            if (type == null) {
                type = elementEntityPersister.getMappedClass();
            } else if (!this.isTreatableAs(elementEntityPersister, type)) {
                throw new IllegalArgumentException(String.format("Collection elements [%s] cannot be treated as requested type [%s] : %s", this.getAttributeName(), type.getName(), elementEntityPersister.getMappedClass().getName()));
            }
        } else {
            EntityPersister entityPersister = (EntityPersister)((Object)joinable);
            if (type == null) {
                type = entityPersister.getMappedClass();
            } else if (!this.isTreatableAs(entityPersister, type)) {
                throw new IllegalArgumentException(String.format("Attribute [%s] cannot be treated as requested type [%s] : %s", this.getAttributeName(), type.getName(), entityPersister.getMappedClass().getName()));
            }
        }
        ManagedType<Object> managedType = null;
        try {
            managedType = this.entityManagerFactory.getEntityTypeByName(type.getName());
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (managedType == null) {
            managedType = this.attribute.getDeclaringType();
        }
        SubgraphImpl subgraph = new SubgraphImpl(this.entityManagerFactory, managedType, type);
        this.subgraphMap.put(type, subgraph);
        return subgraph;
    }

    private boolean isTreatableAs(EntityPersister entityPersister, Class type) {
        return type.isAssignableFrom(entityPersister.getMappedClass());
    }

    public <T> SubgraphImpl<T> makeKeySubgraph() {
        return this.internalMakeKeySubgraph(null);
    }

    public <X extends T> SubgraphImpl<X> makeKeySubgraph(Class<X> type) {
        return this.internalMakeKeySubgraph(type);
    }

    public SubgraphImpl internalMakeKeySubgraph(Class type) {
        if (!this.attribute.isCollection()) {
            throw new IllegalArgumentException(String.format("Non-collection attribute [%s] cannot be target of key subgraph", this.getAttributeName()));
        }
        PluralAttributeImpl pluralAttribute = (PluralAttributeImpl)this.attribute;
        if (pluralAttribute.getCollectionType() != PluralAttribute.CollectionType.MAP) {
            throw new IllegalArgumentException(String.format("Non-Map attribute [%s] cannot be target of key subgraph", this.getAttributeName()));
        }
        AssociationType attributeType = (AssociationType)Helper.resolveType(this.sessionFactory(), this.attribute);
        QueryableCollection collectionPersister = (QueryableCollection)attributeType.getAssociatedJoinable(this.sessionFactory());
        Type indexType = collectionPersister.getIndexType();
        if (!indexType.isAssociationType()) {
            throw new IllegalArgumentException(String.format("Map index [%s] is not an entity; cannot be target of key subgraph", this.getAttributeName()));
        }
        if (this.keySubgraphMap == null) {
            this.keySubgraphMap = new HashMap<Class, Subgraph>();
        }
        AssociationType indexAssociationType = (AssociationType)indexType;
        EntityPersister indexEntityPersister = (EntityPersister)((Object)indexAssociationType.getAssociatedJoinable(this.sessionFactory()));
        if (type == null) {
            type = indexEntityPersister.getMappedClass();
        } else if (!this.isTreatableAs(indexEntityPersister, type)) {
            throw new IllegalArgumentException(String.format("Map key [%s] cannot be treated as requested type [%s] : %s", this.getAttributeName(), type.getName(), indexEntityPersister.getMappedClass().getName()));
        }
        SubgraphImpl subgraph = new SubgraphImpl(this.entityManagerFactory, this.attribute.getDeclaringType(), type);
        this.keySubgraphMap.put(type, subgraph);
        return subgraph;
    }

    @Override
    public AttributeNodeImpl<T> makeImmutableCopy() {
        return new AttributeNodeImpl<T>(this.entityManagerFactory, this.attribute, AttributeNodeImpl.makeSafeMapCopy(this.subgraphMap), AttributeNodeImpl.makeSafeMapCopy(this.keySubgraphMap));
    }

    private static Map<Class, Subgraph> makeSafeMapCopy(Map<Class, Subgraph> subgraphMap) {
        if (subgraphMap == null) {
            return null;
        }
        int properSize = CollectionHelper.determineProperSizing(subgraphMap);
        HashMap<Class, Subgraph> copy = new HashMap<Class, Subgraph>(properSize);
        for (Map.Entry<Class, Subgraph> subgraphEntry : subgraphMap.entrySet()) {
            copy.put(subgraphEntry.getKey(), ((SubgraphImpl)subgraphEntry.getValue()).makeImmutableCopy());
        }
        return copy;
    }
}

