/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.walking.spi;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.PropertyPath;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.walking.spi.AnyMappingDefinition;
import org.hibernate.persister.walking.spi.AssociationAttributeDefinition;
import org.hibernate.persister.walking.spi.AssociationKey;
import org.hibernate.persister.walking.spi.AssociationVisitationStrategy;
import org.hibernate.persister.walking.spi.AttributeDefinition;
import org.hibernate.persister.walking.spi.AttributeSource;
import org.hibernate.persister.walking.spi.CollectionDefinition;
import org.hibernate.persister.walking.spi.CollectionElementDefinition;
import org.hibernate.persister.walking.spi.CollectionIndexDefinition;
import org.hibernate.persister.walking.spi.CompositionDefinition;
import org.hibernate.persister.walking.spi.EncapsulatedEntityIdentifierDefinition;
import org.hibernate.persister.walking.spi.EntityDefinition;
import org.hibernate.persister.walking.spi.EntityIdentifierDefinition;
import org.hibernate.persister.walking.spi.NonEncapsulatedEntityIdentifierDefinition;
import org.hibernate.persister.walking.spi.WalkingException;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class MetamodelGraphWalker {
    private static final Logger log = Logger.getLogger(MetamodelGraphWalker.class);
    private final AssociationVisitationStrategy strategy;
    private final SessionFactoryImplementor factory;
    private PropertyPath currentPropertyPath = new PropertyPath();
    private final Set<AssociationKey> visitedAssociationKeys = new HashSet<AssociationKey>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitEntity(AssociationVisitationStrategy strategy, EntityPersister persister) {
        strategy.start();
        try {
            new MetamodelGraphWalker(strategy, persister.getFactory()).visitEntityDefinition(persister);
        }
        finally {
            strategy.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitCollection(AssociationVisitationStrategy strategy, CollectionPersister persister) {
        strategy.start();
        try {
            new MetamodelGraphWalker(strategy, persister.getFactory()).visitCollectionDefinition(persister);
        }
        finally {
            strategy.finish();
        }
    }

    public MetamodelGraphWalker(AssociationVisitationStrategy strategy, SessionFactoryImplementor factory) {
        this.strategy = strategy;
        this.factory = factory;
    }

    private void visitEntityDefinition(EntityDefinition entityDefinition) {
        this.strategy.startingEntity(entityDefinition);
        this.visitIdentifierDefinition(entityDefinition.getEntityKeyDefinition());
        this.visitAttributes(entityDefinition);
        this.strategy.finishingEntity(entityDefinition);
    }

    private void visitIdentifierDefinition(EntityIdentifierDefinition identifierDefinition) {
        this.strategy.startingEntityIdentifier(identifierDefinition);
        if (identifierDefinition.isEncapsulated()) {
            EncapsulatedEntityIdentifierDefinition idAsEncapsulated = (EncapsulatedEntityIdentifierDefinition)identifierDefinition;
            AttributeDefinition idAttr = idAsEncapsulated.getAttributeDefinition();
            if (CompositionDefinition.class.isInstance(idAttr)) {
                this.visitCompositeDefinition((CompositionDefinition)idAttr);
            }
        } else {
            this.visitCompositeDefinition((NonEncapsulatedEntityIdentifierDefinition)identifierDefinition);
        }
        this.strategy.finishingEntityIdentifier(identifierDefinition);
    }

    private void visitAttributes(AttributeSource attributeSource) {
        Iterable<AttributeDefinition> attributeDefinitions = attributeSource.getAttributes();
        if (attributeDefinitions == null) {
            return;
        }
        for (AttributeDefinition attributeDefinition : attributeSource.getAttributes()) {
            this.visitAttributeDefinition(attributeDefinition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitAttributeDefinition(AttributeDefinition attributeDefinition) {
        AssociationAttributeDefinition associationAttributeDefinition;
        AssociationKey associationKey;
        PropertyPath subPath = this.currentPropertyPath.append(attributeDefinition.getName());
        log.debug("Visiting attribute path : " + subPath.getFullPath());
        if (attributeDefinition.getType().isAssociationType() && this.isDuplicateAssociationKey(associationKey = (associationAttributeDefinition = (AssociationAttributeDefinition)attributeDefinition).getAssociationKey())) {
            log.debug("Property path deemed to be circular : " + subPath.getFullPath());
            this.strategy.foundCircularAssociation(associationAttributeDefinition);
            return;
        }
        boolean continueWalk = this.strategy.startingAttribute(attributeDefinition);
        if (continueWalk) {
            PropertyPath old = this.currentPropertyPath;
            this.currentPropertyPath = subPath;
            try {
                Type attributeType = attributeDefinition.getType();
                if (attributeType.isAssociationType()) {
                    this.visitAssociation((AssociationAttributeDefinition)attributeDefinition);
                } else if (attributeType.isComponentType()) {
                    this.visitCompositeDefinition((CompositionDefinition)attributeDefinition);
                }
            }
            finally {
                this.currentPropertyPath = old;
            }
        }
        this.strategy.finishingAttribute(attributeDefinition);
    }

    private void visitAssociation(AssociationAttributeDefinition attribute) {
        this.addAssociationKey(attribute.getAssociationKey());
        AssociationAttributeDefinition.AssociationNature nature = attribute.getAssociationNature();
        if (nature == AssociationAttributeDefinition.AssociationNature.ANY) {
            this.visitAnyDefinition(attribute.toAnyDefinition());
        } else if (nature == AssociationAttributeDefinition.AssociationNature.COLLECTION) {
            this.visitCollectionDefinition(attribute.toCollectionDefinition());
        } else {
            this.visitEntityDefinition(attribute.toEntityDefinition());
        }
    }

    private void visitAnyDefinition(AnyMappingDefinition anyDefinition) {
        this.strategy.foundAny(anyDefinition);
    }

    private void visitCompositeDefinition(CompositionDefinition compositionDefinition) {
        this.strategy.startingComposite(compositionDefinition);
        this.visitAttributes(compositionDefinition);
        this.strategy.finishingComposite(compositionDefinition);
    }

    private void visitCollectionDefinition(CollectionDefinition collectionDefinition) {
        this.strategy.startingCollection(collectionDefinition);
        this.visitCollectionIndex(collectionDefinition);
        this.visitCollectionElements(collectionDefinition);
        this.strategy.finishingCollection(collectionDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitCollectionIndex(CollectionDefinition collectionDefinition) {
        CollectionIndexDefinition collectionIndexDefinition = collectionDefinition.getIndexDefinition();
        if (collectionIndexDefinition == null) {
            return;
        }
        this.strategy.startingCollectionIndex(collectionIndexDefinition);
        log.debug("Visiting index for collection :  " + this.currentPropertyPath.getFullPath());
        this.currentPropertyPath = this.currentPropertyPath.append("<index>");
        try {
            Type collectionIndexType = collectionIndexDefinition.getType();
            if (collectionIndexType.isAnyType()) {
                this.visitAnyDefinition(collectionIndexDefinition.toAnyMappingDefinition());
            } else if (collectionIndexType.isComponentType()) {
                this.visitCompositeDefinition(collectionIndexDefinition.toCompositeDefinition());
            } else if (collectionIndexType.isAssociationType()) {
                this.visitEntityDefinition(collectionIndexDefinition.toEntityDefinition());
            }
        }
        finally {
            this.currentPropertyPath = this.currentPropertyPath.getParent();
        }
        this.strategy.finishingCollectionIndex(collectionIndexDefinition);
    }

    private void visitCollectionElements(CollectionDefinition collectionDefinition) {
        CollectionElementDefinition elementDefinition = collectionDefinition.getElementDefinition();
        this.strategy.startingCollectionElements(elementDefinition);
        Type collectionElementType = elementDefinition.getType();
        if (collectionElementType.isAnyType()) {
            this.visitAnyDefinition(elementDefinition.toAnyMappingDefinition());
        } else if (collectionElementType.isComponentType()) {
            this.visitCompositeDefinition(elementDefinition.toCompositeElementDefinition());
        } else if (collectionElementType.isEntityType()) {
            if (!collectionDefinition.getCollectionPersister().isOneToMany()) {
                QueryableCollection queryableCollection = (QueryableCollection)collectionDefinition.getCollectionPersister();
                this.addAssociationKey(new AssociationKey(queryableCollection.getTableName(), queryableCollection.getElementColumnNames()));
            }
            this.visitEntityDefinition(elementDefinition.toEntityDefinition());
        }
        this.strategy.finishingCollectionElements(elementDefinition);
    }

    protected void addAssociationKey(AssociationKey associationKey) {
        if (!this.visitedAssociationKeys.add(associationKey)) {
            throw new WalkingException(String.format("Association has already been visited: %s", associationKey));
        }
        this.strategy.associationKeyRegistered(associationKey);
    }

    protected boolean isDuplicateAssociationKey(AssociationKey associationKey) {
        return this.visitedAssociationKeys.contains(associationKey) || this.strategy.isDuplicateAssociationKey(associationKey);
    }
}

