/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.DuplicateJobException;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.support.GroupAwareJob;
import org.springframework.batch.core.configuration.support.ReferenceJobFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.util.Assert;

public class JobRegistryBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
InitializingBean,
DisposableBean {
    private static Log logger = LogFactory.getLog(JobRegistryBeanPostProcessor.class);
    private JobRegistry jobRegistry = null;
    private Collection<String> jobNames = new HashSet<String>();
    private String groupName = null;
    private DefaultListableBeanFactory beanFactory;

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setJobRegistry(JobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof DefaultListableBeanFactory) {
            this.beanFactory = (DefaultListableBeanFactory)beanFactory;
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.jobRegistry, "JobRegistry must not be null");
    }

    @Override
    public void destroy() throws Exception {
        for (String name : this.jobNames) {
            logger.debug("Unregistering job: " + name);
            this.jobRegistry.unregister(name);
        }
        this.jobNames.clear();
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Job) {
            Job job = (Job)bean;
            try {
                String groupName = this.groupName;
                if (this.beanFactory != null && this.beanFactory.containsBean(beanName)) {
                    groupName = this.getGroupName(this.beanFactory.getBeanDefinition(beanName), job);
                }
                job = groupName == null ? job : new GroupAwareJob(groupName, job);
                ReferenceJobFactory jobFactory = new ReferenceJobFactory(job);
                String name = jobFactory.getJobName();
                logger.debug("Registering job: " + name);
                this.jobRegistry.register(jobFactory);
                this.jobNames.add(name);
            }
            catch (DuplicateJobException e) {
                throw new FatalBeanException("Cannot register job configuration", e);
            }
            return job;
        }
        return bean;
    }

    protected String getGroupName(BeanDefinition beanDefinition, Job job) {
        return this.groupName;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

