/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.launch.support;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.configuration.JobLocator;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobExecutionNotFailedException;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.JobExecutionNotStoppedException;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.JobParametersNotFoundException;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.launch.support.ExitCodeMapper;
import org.springframework.batch.core.launch.support.JvmSystemExiter;
import org.springframework.batch.core.launch.support.SimpleJvmExitCodeMapper;
import org.springframework.batch.core.launch.support.SystemExiter;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CommandLineJobRunner {
    protected static final Log logger = LogFactory.getLog(CommandLineJobRunner.class);
    private ExitCodeMapper exitCodeMapper = new SimpleJvmExitCodeMapper();
    private JobLauncher launcher;
    private JobLocator jobLocator;
    private static SystemExiter systemExiter = new JvmSystemExiter();
    private static String message = "";
    private JobParametersConverter jobParametersConverter = new DefaultJobParametersConverter();
    private JobExplorer jobExplorer;
    private JobRepository jobRepository;
    private static final List<String> VALID_OPTS = Arrays.asList("-restart", "-next", "-stop", "-abandon");

    public void setLauncher(JobLauncher launcher) {
        this.launcher = launcher;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setJobExplorer(JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
    }

    public void setExitCodeMapper(ExitCodeMapper exitCodeMapper) {
        this.exitCodeMapper = exitCodeMapper;
    }

    public static void presetSystemExiter(SystemExiter systemExiter) {
        CommandLineJobRunner.systemExiter = systemExiter;
    }

    public static String getErrorMessage() {
        return message;
    }

    public void setSystemExiter(SystemExiter systemExiter) {
        CommandLineJobRunner.systemExiter = systemExiter;
    }

    public void setJobParametersConverter(JobParametersConverter jobParametersConverter) {
        this.jobParametersConverter = jobParametersConverter;
    }

    public void exit(int status) {
        systemExiter.exit(status);
    }

    public void setJobLocator(JobLocator jobLocator) {
        this.jobLocator = jobLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int start(String jobPath, String jobIdentifier, String[] parameters, Set<String> opts) {
        ConfigurableApplicationContext context = null;
        try {
            try {
                context = new AnnotationConfigApplicationContext(Class.forName(jobPath));
            }
            catch (ClassNotFoundException cnfe) {
                context = new ClassPathXmlApplicationContext(jobPath);
            }
            context.getAutowireCapableBeanFactory().autowireBeanProperties(this, 2, false);
            Assert.state(this.launcher != null, "A JobLauncher must be provided.  Please add one to the configuration.");
            if (opts.contains("-restart") || opts.contains("-next")) {
                Assert.state(this.jobExplorer != null, "A JobExplorer must be provided for a restart or start next operation.  Please add one to the configuration.");
            }
            String jobName = jobIdentifier;
            JobParameters jobParameters = this.jobParametersConverter.getJobParameters(StringUtils.splitArrayElementsIntoProperties(parameters, "="));
            Assert.isTrue(parameters == null || parameters.length == 0 || !jobParameters.isEmpty(), "Invalid JobParameters " + Arrays.asList(parameters) + ". If parameters are provided they should be in the form name=value (no whitespace).");
            if (opts.contains("-stop")) {
                List<JobExecution> jobExecutions = this.getRunningJobExecutions(jobIdentifier);
                if (jobExecutions == null) {
                    throw new JobExecutionNotRunningException("No running execution found for job=" + jobIdentifier);
                }
                for (JobExecution jobExecution : jobExecutions) {
                    jobExecution.setStatus(BatchStatus.STOPPING);
                    this.jobRepository.update(jobExecution);
                }
                int i$ = this.exitCodeMapper.intValue(ExitStatus.COMPLETED.getExitCode());
                return i$;
            }
            if (opts.contains("-abandon")) {
                List<JobExecution> jobExecutions = this.getStoppedJobExecutions(jobIdentifier);
                if (jobExecutions == null) {
                    throw new JobExecutionNotStoppedException("No stopped execution found for job=" + jobIdentifier);
                }
                for (JobExecution jobExecution : jobExecutions) {
                    jobExecution.setStatus(BatchStatus.ABANDONED);
                    this.jobRepository.update(jobExecution);
                }
                int i$ = this.exitCodeMapper.intValue(ExitStatus.COMPLETED.getExitCode());
                return i$;
            }
            if (opts.contains("-restart")) {
                JobExecution jobExecution = this.getLastFailedJobExecution(jobIdentifier);
                if (jobExecution == null) {
                    throw new JobExecutionNotFailedException("No failed or stopped execution found for job=" + jobIdentifier);
                }
                jobParameters = jobExecution.getJobParameters();
                jobName = jobExecution.getJobInstance().getJobName();
            }
            Job job = null;
            if (this.jobLocator != null) {
                try {
                    job = this.jobLocator.getJob(jobName);
                }
                catch (NoSuchJobException e) {
                    // empty catch block
                }
            }
            if (job == null) {
                job = (Job)context.getBean(jobName);
            }
            if (opts.contains("-next")) {
                JobParameters nextParameters = this.getNextJobParameters(job);
                HashMap<String, JobParameter> map = new HashMap<String, JobParameter>(nextParameters.getParameters());
                map.putAll(jobParameters.getParameters());
                jobParameters = new JobParameters(map);
            }
            JobExecution jobExecution = this.launcher.run(job, jobParameters);
            int n = this.exitCodeMapper.intValue(jobExecution.getExitStatus().getExitCode());
            return n;
        }
        catch (Throwable e) {
            String message = "Job Terminated in error: " + e.getMessage();
            logger.error(message, e);
            CommandLineJobRunner.message = message;
            int n = this.exitCodeMapper.intValue(ExitStatus.FAILED.getExitCode());
            return n;
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    private List<JobExecution> getJobExecutionsWithStatusGreaterThan(String jobIdentifier, BatchStatus minStatus) {
        Long executionId = this.getLongIdentifier(jobIdentifier);
        if (executionId != null) {
            JobExecution jobExecution = this.jobExplorer.getJobExecution(executionId);
            if (jobExecution.getStatus().isGreaterThan(minStatus)) {
                return Arrays.asList(jobExecution);
            }
            return Collections.emptyList();
        }
        int start = 0;
        int count = 100;
        ArrayList<JobExecution> executions = new ArrayList<JobExecution>();
        List<JobInstance> lastInstances = this.jobExplorer.getJobInstances(jobIdentifier, start, count);
        while (!lastInstances.isEmpty()) {
            for (JobInstance jobInstance : lastInstances) {
                List<JobExecution> jobExecutions = this.jobExplorer.getJobExecutions(jobInstance);
                if (jobExecutions == null || jobExecutions.isEmpty()) continue;
                for (JobExecution jobExecution : jobExecutions) {
                    if (!jobExecution.getStatus().isGreaterThan(minStatus)) continue;
                    executions.add(jobExecution);
                }
            }
            lastInstances = this.jobExplorer.getJobInstances(jobIdentifier, start += count, count);
        }
        return executions;
    }

    private JobExecution getLastFailedJobExecution(String jobIdentifier) {
        List<JobExecution> jobExecutions = this.getJobExecutionsWithStatusGreaterThan(jobIdentifier, BatchStatus.STOPPING);
        if (jobExecutions.isEmpty()) {
            return null;
        }
        return jobExecutions.get(0);
    }

    private List<JobExecution> getStoppedJobExecutions(String jobIdentifier) {
        List<JobExecution> jobExecutions = this.getJobExecutionsWithStatusGreaterThan(jobIdentifier, BatchStatus.STARTED);
        if (jobExecutions.isEmpty()) {
            return null;
        }
        ArrayList<JobExecution> result = new ArrayList<JobExecution>();
        for (JobExecution jobExecution : jobExecutions) {
            if (jobExecution.getStatus() == BatchStatus.ABANDONED) continue;
            result.add(jobExecution);
        }
        return result.isEmpty() ? null : result;
    }

    private List<JobExecution> getRunningJobExecutions(String jobIdentifier) {
        List<JobExecution> jobExecutions = this.getJobExecutionsWithStatusGreaterThan(jobIdentifier, BatchStatus.COMPLETED);
        if (jobExecutions.isEmpty()) {
            return null;
        }
        ArrayList<JobExecution> result = new ArrayList<JobExecution>();
        for (JobExecution jobExecution : jobExecutions) {
            if (!jobExecution.isRunning()) continue;
            result.add(jobExecution);
        }
        return result.isEmpty() ? null : result;
    }

    private Long getLongIdentifier(String jobIdentifier) {
        try {
            return new Long(jobIdentifier);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private JobParameters getNextJobParameters(Job job) throws JobParametersNotFoundException {
        JobParameters jobParameters;
        String jobIdentifier = job.getName();
        List<JobInstance> lastInstances = this.jobExplorer.getJobInstances(jobIdentifier, 0, 1);
        JobParametersIncrementer incrementer = job.getJobParametersIncrementer();
        if (incrementer == null) {
            throw new JobParametersNotFoundException("No job parameters incrementer found for job=" + jobIdentifier);
        }
        if (lastInstances.isEmpty()) {
            jobParameters = incrementer.getNext(new JobParameters());
            if (jobParameters == null) {
                throw new JobParametersNotFoundException("No bootstrap parameters found from incrementer for job=" + jobIdentifier);
            }
        } else {
            List<JobExecution> lastExecutions = this.jobExplorer.getJobExecutions(lastInstances.get(0));
            jobParameters = incrementer.getNext(lastExecutions.get(0).getJobParameters());
        }
        return jobParameters;
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> newargs;
        CommandLineJobRunner command;
        block12: {
            command = new CommandLineJobRunner();
            newargs = new ArrayList<String>(Arrays.asList(args));
            try {
                if (System.in.available() > 0) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                    String line = " ";
                    while (line != null) {
                        if (!line.startsWith("#") && StringUtils.hasText(line)) {
                            logger.debug("Stdin arg: " + line);
                            newargs.add(line);
                        }
                        line = reader.readLine();
                    }
                }
            }
            catch (IOException e) {
                logger.warn("Could not access stdin (maybe a platform limitation)");
                if (!logger.isDebugEnabled()) break block12;
                logger.debug("Exception details", e);
            }
        }
        HashSet<String> opts = new HashSet<String>();
        ArrayList<String> params = new ArrayList<String>();
        int count = 0;
        String jobPath = null;
        String jobIdentifier = null;
        for (String arg : newargs) {
            if (VALID_OPTS.contains(arg)) {
                opts.add(arg);
                continue;
            }
            switch (count) {
                case 0: {
                    jobPath = arg;
                    break;
                }
                case 1: {
                    jobIdentifier = arg;
                    break;
                }
                default: {
                    params.add(arg);
                }
            }
            ++count;
        }
        if (jobPath == null || jobIdentifier == null) {
            String message = "At least 2 arguments are required: JobPath/JobClass and jobIdentifier.";
            logger.error(message);
            CommandLineJobRunner.message = message;
            command.exit(1);
            return;
        }
        String[] parameters = params.toArray(new String[params.size()]);
        int result = command.start(jobPath, jobIdentifier, parameters, opts);
        command.exit(result);
    }
}

