/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.support;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.util.StringUtils;

public enum DatabaseType {
    DERBY("Apache Derby"),
    DB2("DB2"),
    DB2ZOS("DB2ZOS"),
    HSQL("HSQL Database Engine"),
    SQLSERVER("Microsoft SQL Server"),
    MYSQL("MySQL"),
    ORACLE("Oracle"),
    POSTGRES("PostgreSQL"),
    SYBASE("Sybase"),
    H2("H2"),
    SQLITE("SQLite");

    private static final Map<String, DatabaseType> nameMap;
    private final String productName;

    private DatabaseType(String productName) {
        this.productName = productName;
    }

    public String getProductName() {
        return this.productName;
    }

    public static DatabaseType fromProductName(String productName) {
        if (!nameMap.containsKey(productName)) {
            throw new IllegalArgumentException("DatabaseType not found for product name: [" + productName + "]");
        }
        return nameMap.get(productName);
    }

    public static DatabaseType fromMetaData(DataSource dataSource) throws MetaDataAccessException {
        String databaseProductVersion;
        String databaseProductName = JdbcUtils.extractDatabaseMetaData(dataSource, "getDatabaseProductName").toString();
        databaseProductName = StringUtils.hasText(databaseProductName) && !databaseProductName.equals("DB2/Linux") && databaseProductName.startsWith("DB2") ? (!(databaseProductVersion = JdbcUtils.extractDatabaseMetaData(dataSource, "getDatabaseProductVersion").toString()).startsWith("SQL") ? "DB2ZOS" : JdbcUtils.commonDatabaseName(databaseProductName)) : JdbcUtils.commonDatabaseName(databaseProductName);
        return DatabaseType.fromProductName(databaseProductName);
    }

    static {
        nameMap = new HashMap<String, DatabaseType>();
        for (DatabaseType type : DatabaseType.values()) {
            nameMap.put(type.getProductName(), type);
        }
    }
}

