/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.provider;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.metamodel.Metamodel;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.FetchDirection;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlan;
import org.apache.openjpa.persistence.jdbc.LRSSizeAlgorithm;
import org.apache.openjpa.persistence.jdbc.ResultSetType;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.ejb.HibernateQuery;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.data.jpa.provider.JpaClassUtils;
import org.springframework.data.jpa.provider.ProxyIdAccessor;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.util.CloseableIterator;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public enum PersistenceProvider implements QueryExtractor,
ProxyIdAccessor
{
    HIBERNATE(Arrays.asList("org.hibernate.jpa.HibernateEntityManager", "org.hibernate.ejb.HibernateEntityManager"), Arrays.asList("org.hibernate.jpa.internal.metamodel.MetamodelImpl", "org.hibernate.ejb.metamodel.MetamodelImpl")){

        @Override
        public String extractQueryString(Query query) {
            return ((HibernateQuery)query).getHibernateQuery().getQueryString();
        }

        @Override
        public String getCountQueryPlaceholder() {
            return "*";
        }

        @Override
        public boolean shouldUseAccessorFor(Object entity) {
            return entity instanceof HibernateProxy;
        }

        @Override
        public Object getIdentifierFrom(Object entity) {
            return ((HibernateProxy)entity).getHibernateLazyInitializer().getIdentifier();
        }

        @Override
        public <T> Collection<T> potentiallyConvertEmptyCollection(Collection<T> collection) {
            return collection == null || collection.isEmpty() ? null : collection;
        }

        @Override
        public CloseableIterator<Object> executeQueryWithResultStream(Query jpaQuery) {
            return new HibernateScrollableResultsIterator<Object>(jpaQuery);
        }
    }
    ,
    ECLIPSELINK(Collections.singleton("org.eclipse.persistence.jpa.JpaEntityManager"), Collections.singleton("org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl")){

        @Override
        public String extractQueryString(Query query) {
            return ((JpaQuery)query).getDatabaseQuery().getJPQLString();
        }

        @Override
        public boolean shouldUseAccessorFor(Object entity) {
            return false;
        }

        @Override
        public Object getIdentifierFrom(Object entity) {
            return null;
        }

        @Override
        public <T> Collection<T> potentiallyConvertEmptyCollection(Collection<T> collection) {
            return collection == null || collection.isEmpty() ? null : collection;
        }

        @Override
        public CloseableIterator<Object> executeQueryWithResultStream(Query jpaQuery) {
            return new EclipseLinkScrollableResultsIterator<Object>(jpaQuery);
        }
    }
    ,
    OPEN_JPA(Collections.singleton("org.apache.openjpa.persistence.OpenJPAEntityManager"), Collections.singleton("org.apache.openjpa.persistence.meta.MetamodelImpl")){

        @Override
        public String extractQueryString(Query query) {
            return ((OpenJPAQuery)query).getQueryString();
        }

        @Override
        public boolean shouldUseAccessorFor(Object entity) {
            return entity instanceof PersistenceCapable;
        }

        @Override
        public Object getIdentifierFrom(Object entity) {
            return ((PersistenceCapable)entity).pcFetchObjectId();
        }

        @Override
        public CloseableIterator<Object> executeQueryWithResultStream(Query jpaQuery) {
            return new OpenJpaResultStreamingIterator<Object>(jpaQuery);
        }
    }
    ,
    GENERIC_JPA(Collections.singleton("javax.persistence.EntityManager"), Collections.emptySet()){

        @Override
        public String extractQueryString(Query query) {
            return null;
        }

        @Override
        public boolean canExtractQuery() {
            return false;
        }

        @Override
        public boolean shouldUseAccessorFor(Object entity) {
            return false;
        }

        @Override
        public Object getIdentifierFrom(Object entity) {
            return null;
        }
    };

    private final Iterable<String> entityManagerClassNames;
    private final Iterable<String> metamodelClassNames;

    private PersistenceProvider(Iterable<String> entityManagerClassNames, Iterable<String> metamodelClassNames) {
        this.entityManagerClassNames = entityManagerClassNames;
        this.metamodelClassNames = metamodelClassNames;
    }

    public static PersistenceProvider fromEntityManager(EntityManager em) {
        Assert.notNull(em);
        for (PersistenceProvider provider : PersistenceProvider.values()) {
            for (String entityManagerClassName : provider.entityManagerClassNames) {
                if (!JpaClassUtils.isEntityManagerOfType(em, entityManagerClassName)) continue;
                return provider;
            }
        }
        return GENERIC_JPA;
    }

    public static PersistenceProvider fromMetamodel(Metamodel metamodel) {
        Assert.notNull(metamodel, "Metamodel must not be null!");
        for (PersistenceProvider provider : PersistenceProvider.values()) {
            for (String metamodelClassName : provider.metamodelClassNames) {
                if (!JpaClassUtils.isMetamodelOfType(metamodel, metamodelClassName)) continue;
                return provider;
            }
        }
        return GENERIC_JPA;
    }

    @Override
    public boolean canExtractQuery() {
        return true;
    }

    public String getCountQueryPlaceholder() {
        return "x";
    }

    public <T> Collection<T> potentiallyConvertEmptyCollection(Collection<T> collection) {
        return collection;
    }

    public CloseableIterator<Object> executeQueryWithResultStream(Query jpaQuery) {
        throw new UnsupportedOperationException("Streaming results is not implement for this PersistenceProvider: " + this.name());
    }

    private static class OpenJpaResultStreamingIterator<T>
    implements CloseableIterator<T> {
        private final Iterator<T> iterator;

        public OpenJpaResultStreamingIterator(Query jpaQuery) {
            OpenJPAQuery kq = OpenJPAPersistence.cast((Query)jpaQuery);
            JDBCFetchPlan fetch = (JDBCFetchPlan)kq.getFetchPlan();
            fetch.setFetchBatchSize(20);
            fetch.setResultSetType(ResultSetType.SCROLL_SENSITIVE);
            fetch.setFetchDirection(FetchDirection.FORWARD);
            fetch.setLRSSizeAlgorithm(LRSSizeAlgorithm.LAST);
            List resultList = kq.getResultList();
            this.iterator = resultList.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator == null ? false : this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next();
        }

        @Override
        public void close() {
            if (this.iterator != null) {
                OpenJPAPersistence.close(this.iterator);
            }
        }
    }

    private static class EclipseLinkScrollableResultsIterator<T>
    implements CloseableIterator<T> {
        private final ScrollableCursor scrollableCursor;

        public EclipseLinkScrollableResultsIterator(Query jpaQuery) {
            jpaQuery.setHint("eclipselink.cursor.scrollable", true);
            this.scrollableCursor = (ScrollableCursor)jpaQuery.getSingleResult();
        }

        @Override
        public boolean hasNext() {
            return this.scrollableCursor == null ? false : this.scrollableCursor.hasNext();
        }

        @Override
        public T next() {
            return (T)this.scrollableCursor.next();
        }

        @Override
        public void close() {
            if (this.scrollableCursor != null) {
                this.scrollableCursor.close();
            }
        }
    }

    private static class HibernateScrollableResultsIterator<T>
    implements CloseableIterator<T> {
        private final ScrollableResults scrollableResults;
        private static final boolean IS_HIBERNATE3 = ClassUtils.isPresent("org.hibernate.ejb.QueryImpl", HibernateScrollableResultsIterator.class.getClassLoader());

        public HibernateScrollableResultsIterator(Query jpaQuery) {
            org.hibernate.Query query = IS_HIBERNATE3 ? HibernateScrollableResultsIterator.extractHibernate3QueryFrom(jpaQuery) : HibernateScrollableResultsIterator.extractHibernate4Query(jpaQuery);
            this.scrollableResults = query.setReadOnly(TransactionSynchronizationManager.isCurrentTransactionReadOnly()).scroll(ScrollMode.FORWARD_ONLY);
        }

        @Override
        public T next() {
            return (T)this.scrollableResults.get()[0];
        }

        @Override
        public boolean hasNext() {
            return this.scrollableResults == null ? false : this.scrollableResults.next();
        }

        @Override
        public void close() {
            if (this.scrollableResults != null) {
                this.scrollableResults.close();
            }
        }

        private static org.hibernate.Query extractHibernate4Query(Query jpaQuery) {
            Object query = jpaQuery;
            if (jpaQuery.getClass().getName().equals("org.hibernate.jpa.criteria.compile.CriteriaQueryTypeQueryAdapter")) {
                query = new DirectFieldAccessor(jpaQuery).getPropertyValue("jpqlQuery");
            }
            return HibernateScrollableResultsIterator.extractHibernateQueryFromQueryImpl(query);
        }

        private static org.hibernate.Query extractHibernate3QueryFrom(Query jpaQuery) {
            Object query = jpaQuery;
            if (jpaQuery.getClass().isAnonymousClass() && jpaQuery.getClass().getEnclosingClass().getName().equals("org.hibernate.ejb.criteria.CriteriaQueryCompiler")) {
                query = new DirectFieldAccessor(jpaQuery).getPropertyValue("val$jpaqlQuery");
            }
            return HibernateScrollableResultsIterator.extractHibernateQueryFromQueryImpl(query);
        }

        private static org.hibernate.Query extractHibernateQueryFromQueryImpl(Object queryImpl) {
            return (org.hibernate.Query)new DirectFieldAccessor(queryImpl).getPropertyValue("query");
        }
    }

    static interface Constants {
        public static final String GENERIC_JPA_ENTITY_MANAGER_INTERFACE = "javax.persistence.EntityManager";
        public static final String OPENJPA_ENTITY_MANAGER_INTERFACE = "org.apache.openjpa.persistence.OpenJPAEntityManager";
        public static final String ECLIPSELINK_ENTITY_MANAGER_INTERFACE = "org.eclipse.persistence.jpa.JpaEntityManager";
        public static final String HIBERNATE_ENTITY_MANAGER_INTERFACE = "org.hibernate.ejb.HibernateEntityManager";
        public static final String HIBERNATE43_ENTITY_MANAGER_INTERFACE = "org.hibernate.jpa.HibernateEntityManager";
        public static final String HIBERNATE_JPA_METAMODEL_TYPE = "org.hibernate.ejb.metamodel.MetamodelImpl";
        public static final String HIBERNATE43_JPA_METAMODEL_TYPE = "org.hibernate.jpa.internal.metamodel.MetamodelImpl";
        public static final String ECLIPSELINK_JPA_METAMODEL_TYPE = "org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl";
        public static final String OPENJPA_JPA_METAMODEL_TYPE = "org.apache.openjpa.persistence.meta.MetamodelImpl";
    }
}

