/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class Jpa21Utils {
    private static final Method GET_ENTITY_GRAPH_METHOD;
    private static final boolean JPA21_AVAILABLE;

    private Jpa21Utils() {
    }

    public static Map<String, Object> tryGetFetchGraphHints(EntityManager em, JpaEntityGraph entityGraph) {
        if (entityGraph == null) {
            return Collections.emptyMap();
        }
        EntityGraph<?> graph = Jpa21Utils.tryGetFetchGraph(em, entityGraph);
        if (graph == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(entityGraph.getType().getKey(), graph);
    }

    public static EntityGraph<?> tryGetFetchGraph(EntityManager em, JpaEntityGraph jpaEntityGraph) {
        Assert.notNull(em, "EntityManager must not be null!");
        Assert.notNull(jpaEntityGraph, "EntityGraph must not be null!");
        Assert.isTrue(JPA21_AVAILABLE, "The EntityGraph-Feature requires at least a JPA 2.1 persistence provider!");
        Assert.isTrue(GET_ENTITY_GRAPH_METHOD != null, "It seems that you have the JPA 2.1 API but a JPA 2.0 implementation on the classpath!");
        return em.getEntityGraph(jpaEntityGraph.getName());
    }

    static {
        JPA21_AVAILABLE = ClassUtils.isPresent("javax.persistence.NamedEntityGraph", Jpa21Utils.class.getClassLoader());
        GET_ENTITY_GRAPH_METHOD = JPA21_AVAILABLE ? ReflectionUtils.findMethod(EntityManager.class, "getEntityGraph", String.class) : null;
    }
}

