/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.projection;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.CollectionFactory;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

class ProjectingMethodInterceptor
implements MethodInterceptor {
    private final ProjectionFactory factory;
    private final MethodInterceptor delegate;

    public ProjectingMethodInterceptor(ProjectionFactory factory, MethodInterceptor delegate) {
        Assert.notNull(factory, "ProjectionFactory must not be null!");
        Assert.notNull(delegate, "Delegate MethodInterceptor must not be null!");
        this.factory = factory;
        this.delegate = delegate;
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result = this.delegate.invoke(invocation);
        if (result == null) {
            return null;
        }
        TypeInformation type = ClassTypeInformation.fromReturnTypeOf(invocation.getMethod());
        if (type.isCollectionLike() && !ClassUtils.isPrimitiveArray(type.getType())) {
            return this.projectCollectionElements(ProjectingMethodInterceptor.asCollection(result), type);
        }
        if (type.isMap()) {
            return this.projectMapValues((Map)result, type);
        }
        return this.getProjection(result, type.getType());
    }

    private Object projectCollectionElements(Collection<?> sources, TypeInformation<?> type) {
        Class<?> rawType = type.getType();
        Collection<Object> result = CollectionFactory.createCollection(rawType.isArray() ? List.class : rawType, sources.size());
        for (Object source : sources) {
            result.add(this.getProjection(source, type.getComponentType().getType()));
        }
        if (rawType.isArray()) {
            return result.toArray((Object[])Array.newInstance(type.getComponentType().getType(), result.size()));
        }
        return result;
    }

    private Map<Object, Object> projectMapValues(Map<?, ?> sources, TypeInformation<?> type) {
        Map<Object, Object> result = CollectionFactory.createMap(type.getType(), sources.size());
        for (Map.Entry<?, ?> source : sources.entrySet()) {
            result.put(source.getKey(), this.getProjection(source.getValue(), type.getMapValueType().getType()));
        }
        return result;
    }

    private Object getProjection(Object result, Class<?> returnType) {
        return ClassUtils.isAssignable(returnType, result.getClass()) ? result : this.factory.createProjection(returnType, result);
    }

    private static Collection<?> asCollection(Object source) {
        Assert.notNull(source, "Source object must not be null!");
        if (source instanceof Collection) {
            return (Collection)source;
        }
        if (source.getClass().isArray()) {
            return Arrays.asList(ObjectUtils.toObjectArray(source));
        }
        return Collections.singleton(source);
    }
}

