/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.web.MapDataBinder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.ModelAttributeMethodProcessor;

public class ProxyingHandlerMethodArgumentResolver
extends ModelAttributeMethodProcessor
implements BeanFactoryAware,
ResourceLoaderAware {
    private final SpelAwareProxyProjectionFactory proxyFactory = new SpelAwareProxyProjectionFactory();
    private final ConversionService conversionService;

    public ProxyingHandlerMethodArgumentResolver(ConversionService conversionService) {
        super(true);
        this.conversionService = conversionService;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.proxyFactory.setBeanFactory(beanFactory);
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.proxyFactory.setResourceLoader(resourceLoader);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterType().isInterface();
    }

    protected Object createAttribute(String attributeName, MethodParameter parameter, WebDataBinderFactory binderFactory, NativeWebRequest request) throws Exception {
        MapDataBinder binder = new MapDataBinder(parameter.getParameterType(), this.conversionService);
        binder.bind(new MutablePropertyValues(request.getParameterMap()));
        return this.proxyFactory.createProjection((Class)parameter.getParameterType(), binder.getTarget());
    }

    protected void bindRequestParameters(WebDataBinder binder, NativeWebRequest request) {
    }
}

