/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.math.BigDecimal;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Operation;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;

public class OpPlus
extends Operator {
    public OpPlus(int pos, SpelNodeImpl ... operands) {
        super("+", pos, operands);
        Assert.notEmpty(operands);
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        SpelNodeImpl leftOp = this.getLeftOperand();
        SpelNodeImpl rightOp = this.getRightOperand();
        if (rightOp == null) {
            Object operandOne = leftOp.getValueInternal(state).getValue();
            if (operandOne instanceof Number) {
                if (operandOne instanceof Double || operandOne instanceof Long || operandOne instanceof BigDecimal) {
                    return new TypedValue(operandOne);
                }
                if (operandOne instanceof Float) {
                    return new TypedValue(Float.valueOf(((Number)operandOne).floatValue()));
                }
                return new TypedValue(((Number)operandOne).intValue());
            }
            return state.operate(Operation.ADD, operandOne, null);
        }
        TypedValue operandOneValue = leftOp.getValueInternal(state);
        Object leftOperand = operandOneValue.getValue();
        TypedValue operandTwoValue = rightOp.getValueInternal(state);
        Object rightOperand = operandTwoValue.getValue();
        if (leftOperand instanceof Number && rightOperand instanceof Number) {
            Number leftNumber = (Number)leftOperand;
            Number rightNumber = (Number)rightOperand;
            if (leftNumber instanceof BigDecimal || rightNumber instanceof BigDecimal) {
                BigDecimal leftBigDecimal = NumberUtils.convertNumberToTargetClass(leftNumber, BigDecimal.class);
                BigDecimal rightBigDecimal = NumberUtils.convertNumberToTargetClass(rightNumber, BigDecimal.class);
                return new TypedValue(leftBigDecimal.add(rightBigDecimal));
            }
            if (leftNumber instanceof Double || rightNumber instanceof Double) {
                return new TypedValue(leftNumber.doubleValue() + rightNumber.doubleValue());
            }
            if (leftNumber instanceof Float || rightNumber instanceof Float) {
                return new TypedValue(Float.valueOf(leftNumber.floatValue() + rightNumber.floatValue()));
            }
            if (leftNumber instanceof Long || rightNumber instanceof Long) {
                return new TypedValue(leftNumber.longValue() + rightNumber.longValue());
            }
            return new TypedValue(leftNumber.intValue() + rightNumber.intValue());
        }
        if (leftOperand instanceof String && rightOperand instanceof String) {
            return new TypedValue((String)leftOperand + (String)rightOperand);
        }
        if (leftOperand instanceof String) {
            StringBuilder result = new StringBuilder((String)leftOperand);
            result.append(rightOperand == null ? "null" : OpPlus.convertTypedValueToString(operandTwoValue, state));
            return new TypedValue(result.toString());
        }
        if (rightOperand instanceof String) {
            StringBuilder result = new StringBuilder(leftOperand == null ? "null" : OpPlus.convertTypedValueToString(operandOneValue, state));
            result.append((String)rightOperand);
            return new TypedValue(result.toString());
        }
        return state.operate(Operation.ADD, leftOperand, rightOperand);
    }

    @Override
    public String toStringAST() {
        if (this.children.length < 2) {
            return "+" + this.getLeftOperand().toStringAST();
        }
        return super.toStringAST();
    }

    @Override
    public SpelNodeImpl getRightOperand() {
        if (this.children.length < 2) {
            return null;
        }
        return this.children[1];
    }

    private static String convertTypedValueToString(TypedValue value, ExpressionState state) {
        TypeConverter typeConverter = state.getEvaluationContext().getTypeConverter();
        TypeDescriptor typeDescriptor = TypeDescriptor.valueOf(String.class);
        if (typeConverter.canConvert(value.getTypeDescriptor(), typeDescriptor)) {
            Object obj = typeConverter.convertValue(value.getValue(), value.getTypeDescriptor(), typeDescriptor);
            return String.valueOf(obj);
        }
        return String.valueOf(value.getValue());
    }
}

