/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.concurrent;

import java.util.concurrent.Callable;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DelegatingSecurityContextCallable<V>
implements Callable<V> {
    private final Callable<V> delegate;
    private final SecurityContext securityContext;
    private final Thread originalThread;
    private boolean enableOnOriginalThread;

    public DelegatingSecurityContextCallable(Callable<V> delegate, SecurityContext securityContext) {
        Assert.notNull(delegate, "delegate cannot be null");
        Assert.notNull(securityContext, "securityContext cannot be null");
        this.delegate = delegate;
        this.securityContext = securityContext;
        this.originalThread = Thread.currentThread();
    }

    public DelegatingSecurityContextCallable(Callable<V> delegate) {
        this(delegate, SecurityContextHolder.getContext());
    }

    public void setEnableOnOriginalThread(boolean enableOnOriginalThread) {
        this.enableOnOriginalThread = enableOnOriginalThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V call() throws Exception {
        if (!this.enableOnOriginalThread && this.originalThread == Thread.currentThread()) {
            return this.delegate.call();
        }
        try {
            SecurityContextHolder.setContext(this.securityContext);
            V v = this.delegate.call();
            return v;
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static <V> Callable<V> create(Callable<V> delegate, SecurityContext securityContext) {
        return securityContext == null ? new DelegatingSecurityContextCallable<V>(delegate) : new DelegatingSecurityContextCallable<V>(delegate, securityContext);
    }
}

