/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model;

import com.amazonaws.services.devicefarm.model.Suite;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSuitesResult
implements Serializable,
Cloneable {
    private List<Suite> suites;
    private String nextToken;

    public List<Suite> getSuites() {
        return this.suites;
    }

    public void setSuites(Collection<Suite> suites) {
        if (suites == null) {
            this.suites = null;
            return;
        }
        this.suites = new ArrayList<Suite>(suites);
    }

    public ListSuitesResult withSuites(Suite ... suites) {
        if (this.suites == null) {
            this.setSuites(new ArrayList<Suite>(suites.length));
        }
        for (Suite ele : suites) {
            this.suites.add(ele);
        }
        return this;
    }

    public ListSuitesResult withSuites(Collection<Suite> suites) {
        this.setSuites(suites);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSuitesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSuites() != null) {
            sb.append("Suites: " + this.getSuites() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSuitesResult)) {
            return false;
        }
        ListSuitesResult other = (ListSuitesResult)obj;
        if (other.getSuites() == null ^ this.getSuites() == null) {
            return false;
        }
        if (other.getSuites() != null && !other.getSuites().equals(this.getSuites())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSuites() == null ? 0 : this.getSuites().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListSuitesResult clone() {
        try {
            return (ListSuitesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

