/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elastictranscoder.model.Pipeline;
import com.amazonaws.services.elastictranscoder.model.Warning;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReadPipelineResult
implements Serializable,
Cloneable {
    private Pipeline pipeline;
    private ListWithAutoConstructFlag<Warning> warnings;

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    public ReadPipelineResult withPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public List<Warning> getWarnings() {
        if (this.warnings == null) {
            this.warnings = new ListWithAutoConstructFlag();
            this.warnings.setAutoConstruct(true);
        }
        return this.warnings;
    }

    public void setWarnings(Collection<Warning> warnings) {
        if (warnings == null) {
            this.warnings = null;
            return;
        }
        ListWithAutoConstructFlag warningsCopy = new ListWithAutoConstructFlag(warnings.size());
        warningsCopy.addAll(warnings);
        this.warnings = warningsCopy;
    }

    public ReadPipelineResult withWarnings(Warning ... warnings) {
        if (this.getWarnings() == null) {
            this.setWarnings(new ArrayList<Warning>(warnings.length));
        }
        for (Warning value : warnings) {
            this.getWarnings().add(value);
        }
        return this;
    }

    public ReadPipelineResult withWarnings(Collection<Warning> warnings) {
        if (warnings == null) {
            this.warnings = null;
        } else {
            ListWithAutoConstructFlag warningsCopy = new ListWithAutoConstructFlag(warnings.size());
            warningsCopy.addAll(warnings);
            this.warnings = warningsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipeline() != null) {
            sb.append("Pipeline: " + this.getPipeline() + ",");
        }
        if (this.getWarnings() != null) {
            sb.append("Warnings: " + this.getWarnings());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipeline() == null ? 0 : this.getPipeline().hashCode());
        hashCode = 31 * hashCode + (this.getWarnings() == null ? 0 : this.getWarnings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadPipelineResult)) {
            return false;
        }
        ReadPipelineResult other = (ReadPipelineResult)obj;
        if (other.getPipeline() == null ^ this.getPipeline() == null) {
            return false;
        }
        if (other.getPipeline() != null && !other.getPipeline().equals(this.getPipeline())) {
            return false;
        }
        if (other.getWarnings() == null ^ this.getWarnings() == null) {
            return false;
        }
        return other.getWarnings() == null || other.getWarnings().equals(this.getWarnings());
    }

    public ReadPipelineResult clone() {
        try {
            return (ReadPipelineResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

