/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.util;

import java.io.IOException;
import java.io.InputStream;
import org.duracloud.storage.domain.DuraStoreInitConfig;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.xml.DuraStoreInitDocumentBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitConfigParser {
    private static Logger log = LoggerFactory.getLogger(InitConfigParser.class);

    public static DuraStoreInitConfig parseInitXml(InputStream initXml) {
        DuraStoreInitConfig initConfig;
        DuraStoreInitDocumentBinding binding = new DuraStoreInitDocumentBinding();
        try {
            initConfig = binding.createFromXml(initXml);
        }
        catch (Exception e) {
            String error = "Unable to read DuraStore init due to error: " + e.getMessage();
            log.error(error);
            throw new StorageException(error, e);
        }
        finally {
            try {
                initXml.close();
            }
            catch (IOException e) {
                log.warn(e.getMessage());
            }
        }
        return initConfig;
    }
}

