/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr;

import java.util.Date;
import java.util.Properties;
import javax.batch.runtime.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.util.Assert;

public class JsrJobExecution
implements javax.batch.runtime.JobExecution {
    private JobExecution execution;
    private JobParametersConverter parametersConverter;

    public JsrJobExecution(JobExecution execution, JobParametersConverter parametersConverter) {
        Assert.notNull(execution, "A JobExecution is required");
        this.execution = execution;
        this.parametersConverter = parametersConverter;
    }

    @Override
    public long getExecutionId() {
        return this.execution.getId();
    }

    @Override
    public String getJobName() {
        return this.execution.getJobInstance().getJobName();
    }

    @Override
    public BatchStatus getBatchStatus() {
        return this.execution.getStatus().getBatchStatus();
    }

    @Override
    public Date getStartTime() {
        return this.execution.getStartTime();
    }

    @Override
    public Date getEndTime() {
        return this.execution.getEndTime();
    }

    @Override
    public String getExitStatus() {
        return this.execution.getExitStatus().getExitCode();
    }

    @Override
    public Date getCreateTime() {
        return this.execution.getCreateTime();
    }

    @Override
    public Date getLastUpdatedTime() {
        return this.execution.getLastUpdated();
    }

    @Override
    public Properties getJobParameters() {
        Properties properties = this.parametersConverter.getProperties(this.execution.getJobParameters());
        properties.remove("jsr_batch_run_id");
        return properties;
    }
}

