/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.step.item;

import java.util.List;
import javax.batch.operations.BatchRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.jsr.step.item.JsrChunkProcessor;
import org.springframework.batch.core.step.item.BatchRetryTemplate;
import org.springframework.batch.core.step.item.Chunk;
import org.springframework.batch.core.step.item.ChunkMonitor;
import org.springframework.batch.core.step.item.ForceRollbackForWriteSkipException;
import org.springframework.batch.core.step.skip.LimitCheckingItemSkipPolicy;
import org.springframework.batch.core.step.skip.SkipException;
import org.springframework.batch.core.step.skip.SkipPolicy;
import org.springframework.batch.core.step.skip.SkipPolicyFailedException;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.classify.Classifier;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryException;
import org.springframework.util.Assert;

public class JsrFaultTolerantChunkProcessor<I, O>
extends JsrChunkProcessor<I, O> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SkipPolicy skipPolicy = new LimitCheckingItemSkipPolicy();
    private Classifier<Throwable, Boolean> rollbackClassifier = new BinaryExceptionClassifier(true);
    private final BatchRetryTemplate batchRetryTemplate;
    private ChunkMonitor chunkMonitor = new ChunkMonitor();
    private boolean hasProcessor = false;

    public JsrFaultTolerantChunkProcessor(ItemReader<? extends I> reader, ItemProcessor<? super I, ? extends O> processor, ItemWriter<? super O> writer, RepeatOperations repeatTemplate, BatchRetryTemplate batchRetryTemplate) {
        super(reader, processor, writer, repeatTemplate);
        this.hasProcessor = processor != null;
        this.batchRetryTemplate = batchRetryTemplate;
    }

    public void setSkipPolicy(SkipPolicy skipPolicy) {
        Assert.notNull(skipPolicy, "A skip policy is required");
        this.skipPolicy = skipPolicy;
    }

    public void setRollbackClassifier(Classifier<Throwable, Boolean> rollbackClassifier) {
        Assert.notNull(rollbackClassifier, "A rollbackClassifier is required");
        this.rollbackClassifier = rollbackClassifier;
    }

    public void setChunkMonitor(ChunkMonitor chunkMonitor) {
        Assert.notNull(chunkMonitor, "A chunkMonitor is required");
        this.chunkMonitor = chunkMonitor;
    }

    @Override
    public void setListeners(List<? extends StepListener> listeners) {
        for (StepListener stepListener : listeners) {
            this.registerListener(stepListener);
        }
    }

    @Override
    public void registerListener(StepListener listener) {
        this.getListener().register(listener);
    }

    @Override
    protected I provide(final StepContribution contribution, final Chunk<I> chunk) throws Exception {
        RetryCallback retryCallback = new RetryCallback<I, Exception>(){

            @Override
            public I doWithRetry(RetryContext arg0) throws Exception {
                while (true) {
                    try {
                        return JsrFaultTolerantChunkProcessor.this.doProvide(contribution, chunk);
                    }
                    catch (Exception e) {
                        if (JsrFaultTolerantChunkProcessor.this.shouldSkip(JsrFaultTolerantChunkProcessor.this.skipPolicy, e, contribution.getStepSkipCount())) {
                            contribution.incrementReadSkipCount();
                            chunk.skip(e);
                            JsrFaultTolerantChunkProcessor.this.getListener().onSkipInRead(e);
                            JsrFaultTolerantChunkProcessor.this.logger.debug("Skipping failed input", e);
                            continue;
                        }
                        JsrFaultTolerantChunkProcessor.this.getListener().onRetryReadException(e);
                        if (((Boolean)JsrFaultTolerantChunkProcessor.this.rollbackClassifier.classify(e)).booleanValue()) {
                            throw e;
                        }
                        throw e;
                    }
                    break;
                }
            }
        };
        RecoveryCallback recoveryCallback = new RecoveryCallback<I>(){

            @Override
            public I recover(RetryContext context) throws Exception {
                Throwable e = context.getLastThrowable();
                if (JsrFaultTolerantChunkProcessor.this.shouldSkip(JsrFaultTolerantChunkProcessor.this.skipPolicy, e, contribution.getStepSkipCount())) {
                    contribution.incrementReadSkipCount();
                    JsrFaultTolerantChunkProcessor.this.logger.debug("Skipping after failed process", e);
                    return null;
                }
                if (((Boolean)JsrFaultTolerantChunkProcessor.this.rollbackClassifier.classify(e)).booleanValue()) {
                    throw new RetryException("Non-skippable exception in recoverer while reading", e);
                }
                throw new BatchRuntimeException(e);
            }
        };
        return (I)this.batchRetryTemplate.execute(retryCallback, recoveryCallback);
    }

    private boolean shouldSkip(SkipPolicy policy, Throwable e, int skipCount) {
        try {
            return policy.shouldSkip(e, skipCount);
        }
        catch (SkipException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new SkipPolicyFailedException("Fatal exception in SkipPolicy.", ex, e);
        }
    }

    @Override
    protected O transform(final StepContribution contribution, final I item) throws Exception {
        if (!this.hasProcessor) {
            return (O)item;
        }
        RetryCallback retryCallback = new RetryCallback<O, Exception>(){

            @Override
            public O doWithRetry(RetryContext context) throws Exception {
                try {
                    return JsrFaultTolerantChunkProcessor.this.doTransform(item);
                }
                catch (Exception e) {
                    if (!JsrFaultTolerantChunkProcessor.this.shouldSkip(JsrFaultTolerantChunkProcessor.this.skipPolicy, e, contribution.getStepSkipCount())) {
                        JsrFaultTolerantChunkProcessor.this.getListener().onRetryProcessException(item, e);
                        if (((Boolean)JsrFaultTolerantChunkProcessor.this.rollbackClassifier.classify(e)).booleanValue()) {
                            throw e;
                        }
                        throw e;
                    }
                    contribution.incrementProcessSkipCount();
                    JsrFaultTolerantChunkProcessor.this.logger.debug("Skipping after failed process with no rollback", e);
                    JsrFaultTolerantChunkProcessor.this.getListener().onSkipInProcess(item, e);
                    return null;
                }
            }
        };
        RecoveryCallback recoveryCallback = new RecoveryCallback<O>(){

            @Override
            public O recover(RetryContext context) throws Exception {
                Throwable e = context.getLastThrowable();
                if (JsrFaultTolerantChunkProcessor.this.shouldSkip(JsrFaultTolerantChunkProcessor.this.skipPolicy, e, contribution.getStepSkipCount())) {
                    contribution.incrementProcessSkipCount();
                    JsrFaultTolerantChunkProcessor.this.logger.debug("Skipping after failed process", e);
                    return null;
                }
                if (((Boolean)JsrFaultTolerantChunkProcessor.this.rollbackClassifier.classify(e)).booleanValue()) {
                    throw new RetryException("Non-skippable exception in recoverer while processing", e);
                }
                throw new BatchRuntimeException(e);
            }
        };
        return (O)this.batchRetryTemplate.execute(retryCallback, recoveryCallback);
    }

    @Override
    protected void persist(final StepContribution contribution, final Chunk<O> chunk) throws Exception {
        RetryCallback<Object, Exception> retryCallback = new RetryCallback<Object, Exception>(){

            @Override
            public Object doWithRetry(RetryContext context) throws Exception {
                JsrFaultTolerantChunkProcessor.this.chunkMonitor.setChunkSize(chunk.size());
                try {
                    JsrFaultTolerantChunkProcessor.this.doPersist(contribution, chunk);
                }
                catch (Exception e) {
                    if (JsrFaultTolerantChunkProcessor.this.shouldSkip(JsrFaultTolerantChunkProcessor.this.skipPolicy, e, contribution.getStepSkipCount())) {
                        JsrFaultTolerantChunkProcessor.this.getListener().onSkipInWrite(chunk.getItems(), e);
                    } else {
                        JsrFaultTolerantChunkProcessor.this.getListener().onRetryWriteException(chunk.getItems(), e);
                        if (((Boolean)JsrFaultTolerantChunkProcessor.this.rollbackClassifier.classify(e)).booleanValue()) {
                            throw e;
                        }
                    }
                    throw new ForceRollbackForWriteSkipException("Force rollback on skippable exception so that skipped item can be located.", e);
                }
                contribution.incrementWriteCount(chunk.size());
                return null;
            }
        };
        RecoveryCallback<Object> recoveryCallback = new RecoveryCallback<Object>(){

            @Override
            public O recover(RetryContext context) throws Exception {
                Throwable e = context.getLastThrowable();
                if (JsrFaultTolerantChunkProcessor.this.shouldSkip(JsrFaultTolerantChunkProcessor.this.skipPolicy, e, contribution.getStepSkipCount())) {
                    contribution.incrementWriteSkipCount();
                    JsrFaultTolerantChunkProcessor.this.logger.debug("Skipping after failed write", e);
                    return null;
                }
                if (((Boolean)JsrFaultTolerantChunkProcessor.this.rollbackClassifier.classify(e)).booleanValue()) {
                    throw new RetryException("Non-skippable exception in recoverer while write", e);
                }
                return null;
            }
        };
        this.batchRetryTemplate.execute(retryCallback, recoveryCallback);
    }
}

