/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.List;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class CompositeItemProcessor<I, O>
implements ItemProcessor<I, O>,
InitializingBean {
    private List<? extends ItemProcessor<?, ?>> delegates;

    @Override
    public O process(I item) throws Exception {
        Object result = item;
        for (ItemProcessor<?, ?> delegate : this.delegates) {
            if (result == null) {
                return null;
            }
            result = this.processItem(delegate, result);
        }
        return (O)result;
    }

    private <T> Object processItem(ItemProcessor<T, ?> processor, Object input) throws Exception {
        return processor.process(input);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.delegates, "The 'delegates' may not be null");
        Assert.notEmpty(this.delegates, "The 'delegates' may not be empty");
    }

    public void setDelegates(List<? extends ItemProcessor<?, ?>> delegates) {
        this.delegates = delegates;
    }
}

