/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.concurrent;

import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

public final class DelegatingSecurityContextRunnable
implements Runnable {
    private final Runnable delegate;
    private final SecurityContext securityContext;
    private final Thread originalThread;
    private boolean enableOnOriginalThread;

    public DelegatingSecurityContextRunnable(Runnable delegate, SecurityContext securityContext) {
        Assert.notNull(delegate, "delegate cannot be null");
        Assert.notNull(securityContext, "securityContext cannot be null");
        this.delegate = delegate;
        this.securityContext = securityContext;
        this.originalThread = Thread.currentThread();
    }

    public DelegatingSecurityContextRunnable(Runnable delegate) {
        this(delegate, SecurityContextHolder.getContext());
    }

    public void setEnableOnOriginalThread(boolean enableOnOriginalThread) {
        this.enableOnOriginalThread = enableOnOriginalThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.enableOnOriginalThread && this.originalThread == Thread.currentThread()) {
            this.delegate.run();
            return;
        }
        try {
            SecurityContextHolder.setContext(this.securityContext);
            this.delegate.run();
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static Runnable create(Runnable delegate, SecurityContext securityContext) {
        Assert.notNull(delegate, "delegate cannot be  null");
        return securityContext == null ? new DelegatingSecurityContextRunnable(delegate) : new DelegatingSecurityContextRunnable(delegate, securityContext);
    }
}

